/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.stage.Window;
import org.tentackle.bind.Bindable;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxCheckBox;
import org.tentackle.fx.component.FxRadioButton;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.container.FxGridPane;
import org.tentackle.fx.rdc.PdoEditor;
import org.tentackle.fx.rdc.security.SecurityDialogFactory;
import org.tentackle.pdo.DomainContext;
import org.tentackle.security.Permission;
import org.tentackle.security.SecurityFactory;
import org.tentackle.security.pdo.Security;
import org.tentackle.security.permissions.AllPermission;

@FxControllerService
public class SecurityEditor
extends PdoEditor<Security> {
    public static final String DENY_STYLE = "sec-deny";
    public static final String ALLOW_STYLE = "sec-allow";
    public static final String NA_STYLE = "sec-na";
    @Bindable
    private Security sec;
    @FXML
    private FxTextField secGranteeField;
    @FXML
    private FxButton granteeButton;
    @FXML
    private FxTextField secDomainContextObjectField;
    @FXML
    private FxButton contextButton;
    @FXML
    private FxRadioButton allowButton;
    @FXML
    private FxRadioButton denyButton;
    @FXML
    private FxGridPane permissionPane;
    @FXML
    private FxTextArea secMessageField;
    private Class<?> clazz;
    private Map<Permission, FxCheckBox> permissionCheckBoxes;
    private Map<Permission, FxRadioButton> permissionRadioButtons;
    private Set<Permission> inheritedPermissions;

    @FXML
    private void initialize() {
        this.secGranteeField.setChangeable(false);
        this.granteeButton.setOnAction(e -> this.selectGrantee());
        this.allowButton.setBindable(false);
        this.denyButton.setBindable(false);
        ToggleGroup group = new ToggleGroup();
        this.allowButton.setToggleGroup(group);
        this.allowButton.getStyleClass().add((Object)ALLOW_STYLE);
        this.denyButton.setToggleGroup(group);
        this.denyButton.getStyleClass().add((Object)DENY_STYLE);
        group.selectedToggleProperty().addListener(obs -> {
            if (group.getSelectedToggle() == this.allowButton) {
                this.sec.setAllowed(true);
            } else if (group.getSelectedToggle() == this.denyButton) {
                this.sec.setAllowed(false);
            }
            this.updateEffectivePermissions();
        });
        this.allowButton.addViewToModelListener(this::handleSelectionEvent);
        this.denyButton.addViewToModelListener(this::handleSelectionEvent);
        this.permissionCheckBoxes = new TreeMap<Permission, FxCheckBox>();
        this.permissionRadioButtons = new HashMap<Permission, FxRadioButton>();
        this.inheritedPermissions = new HashSet<Permission>();
        for (Class permissionIf : SecurityFactory.getInstance().getPermissionInterfaces()) {
            Permission permission = SecurityFactory.getInstance().getPermission(permissionIf);
            FxCheckBox checkBox = (FxCheckBox)Fx.create(CheckBox.class);
            String description = permission.getDescription();
            if (description != null) {
                checkBox.setTooltip(new Tooltip(description));
            }
            checkBox.setText(permission.getName());
            checkBox.setBindable(false);
            checkBox.addViewToModelListener(this::handleSelectionEvent);
            this.permissionCheckBoxes.put(permission, checkBox);
            FxRadioButton effectiveRadioButton = (FxRadioButton)Fx.create(RadioButton.class);
            effectiveRadioButton.setBindable(false);
            effectiveRadioButton.setChangeable(false);
            this.permissionRadioButtons.put(permission, effectiveRadioButton);
        }
        if (!SecurityDialogFactory.getInstance().isDomainContextUsed()) {
            this.contextButton.setDisable(true);
            this.secDomainContextObjectField.setDisable(true);
        } else {
            this.contextButton.setOnAction(e -> this.selectContext());
        }
    }

    public Security getPdo() {
        return this.sec;
    }

    @Override
    public void setPdo(Security pdo) {
        Class[] permissions;
        this.sec = pdo;
        this.getBinder().putBindingProperty(DomainContext.class, (Object)pdo.getDomainContext());
        if (pdo.isAllowed()) {
            this.allowButton.setSelected(true);
        } else {
            this.denyButton.setSelected(true);
        }
        for (FxCheckBox checkBox : this.permissionCheckBoxes.values()) {
            checkBox.setSelected(false);
        }
        for (Class permission : permissions = SecurityFactory.getInstance().stringToPermissionInterfaces(pdo.getPermissions())) {
            FxCheckBox box = this.permissionCheckBoxes.get(SecurityFactory.getInstance().getPermission(permission));
            if (box == null) continue;
            box.setSelected(true);
        }
        this.getContainer().updateView();
        this.updateEffectivePermissions();
    }

    public void setSecurableClass(Class<?> clazz) {
        this.clazz = clazz;
        this.permissionPane.getChildren().remove(2, this.permissionPane.getChildren().size());
        int row = 1;
        for (Map.Entry<Permission, FxCheckBox> entry : this.permissionCheckBoxes.entrySet()) {
            Permission permission = entry.getKey();
            if (!permission.appliesTo(clazz)) continue;
            this.permissionPane.add((Node)entry.getValue(), 0, row);
            this.permissionPane.add((Node)this.permissionRadioButtons.get(permission), 1, row);
            ++row;
        }
    }

    @Override
    public void requestInitialFocus() {
        this.allowButton.requestFocus();
    }

    @Override
    public void setChangeable(boolean changeable) {
        super.setChangeable(changeable);
        this.granteeButton.setDisable(!changeable);
    }

    private void selectGrantee() {
        SecurityDialogFactory.getInstance().selectGrantee((Window)this.getStage(), this.getDomainContext(), grantee -> {
            this.sec.setGrantee(grantee);
            this.secGranteeField.updateView();
            this.getContainer().getDelegate().fireViewToModelListeners();
        });
    }

    private void selectContext() {
        SecurityDialogFactory.getInstance().selectDomainContextObject((Window)this.getStage(), this.getDomainContext(), contextPdo -> {
            this.sec.setDomainContextObject(contextPdo);
            this.secDomainContextObjectField.updateView();
            this.getContainer().getDelegate().fireViewToModelListeners();
        });
    }

    private void handleSelectionEvent() {
        this.updateEffectivePermissions();
        this.permissionsToModel();
    }

    private void updateEffectivePermissions() {
        this.inheritedPermissions.clear();
        HashSet<Class> selectedPermissions = new HashSet<Class>();
        for (Map.Entry<Permission, FxCheckBox> entry : this.permissionCheckBoxes.entrySet()) {
            if (!entry.getValue().isSelected() || !entry.getKey().appliesTo(this.clazz)) continue;
            selectedPermissions.add(entry.getKey().getPermissionInterface());
        }
        Class[] permissions = selectedPermissions.toArray(new Class[0]);
        for (Map.Entry<Permission, FxRadioButton> entry : this.permissionRadioButtons.entrySet()) {
            boolean appliesEffectively;
            Permission permission = entry.getKey();
            if (!permission.appliesTo(this.clazz)) continue;
            Class permissionIf = permission.getPermissionInterface();
            FxRadioButton effectiveRadioButton = entry.getValue();
            FxCheckBox box = this.permissionCheckBoxes.get(permission);
            boolean inherited = false;
            boolean isAllPermission = permission instanceof AllPermission;
            if (this.sec.isAllowed()) {
                if (!effectiveRadioButton.getStyleClass().contains((Object)ALLOW_STYLE)) {
                    effectiveRadioButton.getStyleClass().add((Object)ALLOW_STYLE);
                }
                effectiveRadioButton.getStyleClass().remove((Object)DENY_STYLE);
                boolean bl = appliesEffectively = permission.appliesTo(this.clazz) && permission.isAllowedBy(permissions) && (!isAllPermission || box.isSelected());
                if (appliesEffectively && !isAllPermission) {
                    for (Class iFace : permissions) {
                        if (!AllPermission.class.isAssignableFrom(iFace) && (permissionIf == iFace || !permissionIf.isAssignableFrom(iFace))) continue;
                        inherited = true;
                        break;
                    }
                }
            } else {
                if (!effectiveRadioButton.getStyleClass().contains((Object)DENY_STYLE)) {
                    effectiveRadioButton.getStyleClass().add((Object)DENY_STYLE);
                }
                effectiveRadioButton.getStyleClass().remove((Object)ALLOW_STYLE);
                boolean bl = appliesEffectively = permission.appliesTo(this.clazz) && permission.isDeniedBy(permissions) && (!isAllPermission || box.isSelected());
                if (appliesEffectively && !isAllPermission) {
                    for (Class iFace : permissions) {
                        if (!AllPermission.class.isAssignableFrom(iFace) && (permissionIf == iFace || !iFace.isAssignableFrom(permissionIf))) continue;
                        inherited = true;
                        break;
                    }
                }
            }
            effectiveRadioButton.setSelected(appliesEffectively);
            if (inherited) {
                if (!isAllPermission) {
                    this.inheritedPermissions.add(permission);
                }
                if (box.getStyleClass().contains((Object)NA_STYLE)) continue;
                box.getStyleClass().add((Object)NA_STYLE);
                continue;
            }
            box.getStyleClass().remove((Object)NA_STYLE);
        }
    }

    private void permissionsToModel() {
        LinkedHashSet<Permission> permissions = new LinkedHashSet<Permission>();
        for (Map.Entry<Permission, FxCheckBox> entry : this.permissionCheckBoxes.entrySet()) {
            Permission permission = entry.getKey();
            if (!entry.getValue().isSelected() || !permission.appliesTo(this.clazz) || this.inheritedPermissions.contains(permission)) continue;
            permissions.add(permission);
        }
        this.sec.setPermissions(permissions.isEmpty() ? null : SecurityFactory.getInstance().permissionsToString(permissions));
    }
}

