/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.Cursor;
import javafx.scene.Node;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.rdc.RdcUtilities;
import org.tentackle.session.ModificationTracker;
import org.tentackle.session.Session;
import org.tentackle.session.SessionCloseHandler;
import org.tentackle.session.SessionPool;
import org.tentackle.session.SessionPoolFactory;
import org.tentackle.session.SessionPooledExecutor;

public class RdcUtilitiesWithBackgroundPool
extends RdcUtilities {
    private final SessionPooledExecutor executor = this.createExecutor();

    public SessionPooledExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public <V> void runInBackground(Node node, Supplier<V> runner, Consumer<V> updateUI, Consumer<RuntimeException> failedUI) {
        Cursor oldCursor;
        if (node != null) {
            oldCursor = node.getCursor();
            node.setCursor(FxUtilities.getInstance().getWaitCursor(node));
        } else {
            oldCursor = null;
        }
        this.executor.submit(runner, value -> Platform.runLater(() -> {
            this.restoreDefaultCursor(node, oldCursor);
            if (updateUI != null) {
                updateUI.accept(value);
            }
        }), exception -> Platform.runLater(() -> {
            this.restoreDefaultCursor(node, oldCursor);
            if (failedUI != null) {
                failedUI.accept((RuntimeException)exception);
            }
        }));
    }

    public <V> void runInBackground(Node node, Collection<Supplier<V>> runners, long timeoutMillis, Consumer<Map<Supplier<V>, V>> finishedUI, Consumer<Map<Supplier<V>, RuntimeException>> failedUI) {
        Cursor oldCursor;
        if (node != null) {
            oldCursor = node.getCursor();
            node.setCursor(FxUtilities.getInstance().getWaitCursor(node));
        } else {
            oldCursor = null;
        }
        this.executor.submit(runners, timeoutMillis, successHandler -> Platform.runLater(() -> {
            this.restoreDefaultCursor(node, oldCursor);
            if (finishedUI != null) {
                finishedUI.accept((Map)successHandler);
            }
        }), failHandler -> Platform.runLater(() -> {
            this.restoreDefaultCursor(node, oldCursor);
            if (failedUI != null) {
                failedUI.accept((Map)failHandler);
            }
        }));
    }

    public <V> void runInBackground(Node node, Collection<Supplier<V>> runners, long timeoutMillis, Consumer<Map<Supplier<V>, V>> finishedUI) {
        this.runInBackground(node, runners, timeoutMillis, finishedUI, failedMap -> {
            StringBuilder buf = new StringBuilder();
            for (RuntimeException rx : failedMap.values()) {
                String msg = rx.getLocalizedMessage();
                if (msg == null || buf.toString().contains(msg)) continue;
                if (!buf.isEmpty()) {
                    buf.append('\n');
                }
                buf.append(rx.getLocalizedMessage());
            }
            String msg = buf.toString();
            Platform.runLater(() -> Fx.warning((Object)node, (String)msg));
        });
    }

    protected SessionPooledExecutor createExecutor() {
        Session session = ModificationTracker.getInstance().getSession();
        final SessionPooledExecutor executor = new SessionPooledExecutor(this.createSessionPool(session));
        session.registerCloseHandler(new SessionCloseHandler(){

            public void beforeClose(Session session) {
            }

            public void afterClose(Session session) {
                executor.shutdown();
            }
        });
        return executor;
    }

    protected SessionPool createSessionPool(Session session) {
        return SessionPoolFactory.getInstance().create("BG", session, 0, 1, 0, 3, 5L, 0L);
    }

    protected void restoreDefaultCursor(Node node, Cursor oldCursor) {
        if (node != null) {
            node.setCursor(oldCursor == null ? null : FxUtilities.getInstance().getDefaultCursor(node));
        }
    }
}

