/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.app;

import javafx.stage.Stage;
import org.tentackle.app.Application;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.rdc.app.DesktopApplication;
import org.tentackle.log.Logger;

public abstract class FxApplication
extends javafx.application.Application {
    private static final Logger LOGGER = Logger.get(FxApplication.class);
    private static final String FATAL = "runtime or configuration error";
    private int exitValue;
    private Throwable exitThrowable;

    public void start(Stage stage) {
        try {
            DesktopApplication application = (DesktopApplication)Application.getInstance();
            application.setFxApplication(this);
            application.registerUncaughtExceptionHandler();
            this.startApplication(stage);
        }
        catch (RuntimeException ex) {
            LOGGER.severe("starting tentackle fx application failed", (Throwable)ex);
            throw ex;
        }
        catch (Throwable t) {
            LOGGER.severe(FATAL, t);
            throw new FxRuntimeException(FATAL, t);
        }
    }

    public void setStopReason(int exitValue, Throwable exitThrowable) {
        this.exitValue = exitValue;
        this.exitThrowable = exitThrowable;
    }

    public void stop() {
        Application tentackleApplication = Application.getInstance();
        if (tentackleApplication != null) {
            tentackleApplication.stop(this.exitValue, this.exitThrowable);
        }
    }

    public abstract void startApplication(Stage var1);

    public abstract void showApplicationStatus(String var1, double var2);
}

