/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.search;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.tentackle.common.StringHelper;
import org.tentackle.common.StringNormalizer;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.CaseConversion;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxLabel;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.component.FxTreeView;
import org.tentackle.fx.container.FxBorderPane;
import org.tentackle.fx.container.FxHBox;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.PdoController;
import org.tentackle.fx.rdc.PdoEvent;
import org.tentackle.fx.rdc.PdoFinder;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.RdcRuntimeException;
import org.tentackle.fx.rdc.crud.PdoCrud;
import org.tentackle.fx.rdc.table.TablePopup;
import org.tentackle.fx.table.TotalsTableView;
import org.tentackle.misc.Holder;
import org.tentackle.pdo.PersistentDomainObject;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class PdoSearch<T extends PersistentDomainObject<T>>
extends AbstractFxController
implements PdoController<T> {
    @FXML
    private FxBorderPane borderPane;
    @FXML
    private FxHBox buttonBox;
    @FXML
    private FxButton findButton;
    @FXML
    private FxButton okButton;
    @FXML
    private FxButton newButton;
    @FXML
    private FxButton cancelButton;
    @FXML
    private FxButton filterButton;
    @FXML
    private FxTextField filterField;
    @FXML
    private FxButton treeButton;
    @FXML
    private FxLabel countLabel;
    @FXML
    private ResourceBundle resources;
    private SortedList<T> items = new SortedList(FXCollections.observableArrayList());
    private InvalidationListener itemsListener;
    private PdoFinder<T> finder;
    private boolean viewSelectionPending;
    private PdoCrud<T> pdoCrud;
    private FxBorderPane tablePane;
    private FxTableView<T> tableView;
    private TotalsTableView<T> totalsView;
    private FxTreeView<T> treeView;
    private boolean treeShown;
    private TreeItem<T> rootItem;
    private boolean tableViewInvalid;
    private boolean treeViewInvalid;
    private boolean singleSelectMode;
    private BooleanProperty wrongTypeSelected;
    private T createdPdo;
    private Consumer<T> doubleClickHandler;
    private String noDataMessage;
    private Node searchIcon;
    private Node searchPlusIcon;
    private boolean shiftDown;
    private boolean mouseOverFindButton;

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public void setNoDataMessage(String noDataMessage) {
        this.noDataMessage = noDataMessage;
    }

    public Consumer<T> getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public void setDoubleClickHandler(Consumer<T> doubleClickHandler) {
        this.doubleClickHandler = doubleClickHandler;
    }

    public FxHBox getButtonBox() {
        return this.buttonBox;
    }

    public void setFinder(PdoFinder<T> finder) {
        if (this.finder != null) {
            throw new RdcRuntimeException("finder already set");
        }
        this.finder = finder;
        this.viewSelectionPending = true;
        Parent finderView = finder.getView();
        this.borderPane.setTop((Node)finderView);
        BorderPane.setMargin((Node)finderView, (Insets)new Insets(5.0));
    }

    public PdoFinder<T> getFinder() {
        return this.finder;
    }

    @Override
    public void setPdo(T pdo) {
        ObjectProperty<EventHandler<ActionEvent>> searchActionProperty;
        Objects.requireNonNull(pdo, "pdo");
        this.createdPdo = null;
        this.finder.setPdo((PersistentDomainObject)pdo);
        this.finder.getContainer().updateView();
        this.setFinderVisible(this.finder.isVisible());
        GuiProvider<T> guiProvider = Rdc.createGuiProvider(pdo);
        this.tableView = guiProvider.createTableView();
        this.tablePane.setCenter(this.tableView);
        this.tableView.setOnMousePressed(event -> {
            PersistentDomainObject firstPdo;
            if (event.isPrimaryButtonDown() && event.getClickCount() == 2 && (firstPdo = (PersistentDomainObject)this.tableView.getSelectionModel().getSelectedItem()) != null) {
                if (Fx.isModal((Stage)this.getStage())) {
                    this.close();
                } else if (this.doubleClickHandler != null) {
                    this.doubleClickHandler.accept(firstPdo);
                } else if (Rdc.createGuiProvider(firstPdo).isEditorAvailable()) {
                    if (this.isCrudShown()) {
                        this.pdoCrud.releasePdo(released -> {
                            if (released.booleanValue()) {
                                Stage stage = Rdc.getCrud(firstPdo, true);
                                if (stage != null) {
                                    stage.toFront();
                                } else {
                                    this.pdoCrud.setPdo(firstPdo.reload());
                                }
                            }
                        });
                    } else {
                        Rdc.displayCrudStage(firstPdo.reload(), this.items, true, Modality.NONE, (Window)this.getStage(), null, crud -> {
                            this.pdoCrud = crud;
                            crud.addPdoEventFilter(PdoEvent.ANY, (EventHandler<PdoEvent>)((EventHandler)e -> {
                                if (e.getEventType() == PdoEvent.UPDATE) {
                                    int ndx;
                                    PersistentDomainObject updatedPdo = firstPdo.reload();
                                    if (!this.treeViewInvalid) {
                                        ObservableList treeItems = this.treeView.getRoot().getChildren();
                                        int i = 0;
                                        for (TreeItem item : treeItems) {
                                            if (updatedPdo.equals(item.getValue())) {
                                                TreeItem<PersistentDomainObject> updatedItem = Rdc.createGuiProvider(updatedPdo).createTreeItem();
                                                treeItems.set(i, updatedItem);
                                                updatedItem.setExpanded(item.isExpanded());
                                                break;
                                            }
                                            ++i;
                                        }
                                    }
                                    if ((ndx = this.items.indexOf((Object)updatedPdo)) >= 0) {
                                        this.items.getSource().set(this.items.getSourceIndex(ndx), updatedPdo);
                                    }
                                } else if (e.getEventType() == PdoEvent.READ) {
                                    int ndx;
                                    int n = ndx = this.treeViewInvalid ? this.tableView.getSelectionModel().getSelectedIndex() : -1;
                                    ndx = ndx > 0 && e.getPdo().equals(this.items.get(ndx - 1)) ? --ndx : (ndx < this.items.size() - 1 && ndx >= 0 && e.getPdo().equals(this.items.get(ndx + 1)) ? ++ndx : this.items.indexOf(e.getPdo()));
                                    if (ndx >= 0) {
                                        if (this.treeViewInvalid) {
                                            this.tableView.getSelectionModel().clearSelection();
                                            this.tableView.getSelectionModel().select(ndx);
                                            this.tableView.scrollToCentered(ndx);
                                        } else {
                                            this.treeView.getSelectionModel().clearSelection();
                                            TreeItem selectedItem = (TreeItem)this.rootItem.getChildren().get(ndx);
                                            this.treeView.getSelectionModel().select((Object)selectedItem);
                                            ndx = this.treeView.getSelectionModel().getSelectedIndex();
                                            if (ndx >= 0) {
                                                this.treeView.scrollToCentered(ndx);
                                            }
                                        }
                                    }
                                }
                                e.consume();
                            }));
                        });
                    }
                }
            }
        });
        TablePopup<T> tablePopup = Rdc.createTablePopup(this.tableView, null, pdo.getPlural());
        tablePopup.loadPreferences();
        this.treeView = (FxTreeView)Fx.create(TreeView.class);
        this.treeView.setCellFactory(guiProvider.getTreeCellFactory());
        this.wrongTypeSelected = new SimpleBooleanProperty();
        this.treeView.getSelectionModel().selectedItemProperty().addListener((obs, ov, nv) -> this.wrongTypeSelected.set(nv == null || nv.getValue() == null || !pdo.getClass().isAssignableFrom(((PersistentDomainObject)nv.getValue()).getClass())));
        StackPane stackPane = (StackPane)Fx.create(StackPane.class);
        if (this.treeShown) {
            stackPane.getChildren().addAll((Object[])new Node[]{this.tablePane, this.treeView});
        } else {
            stackPane.getChildren().addAll((Object[])new Node[]{this.treeView, this.tablePane});
        }
        this.treeViewInvalid = true;
        this.tableViewInvalid = true;
        this.borderPane.setCenter((Node)stackPane);
        this.filterField.setVisible(false);
        this.filterField.setCaseConversion(CaseConversion.UPPER_CASE);
        this.filterButton.setVisible(false);
        this.updateTitle();
        this.bindOkButton();
        if (this.finder.isSearchRunningImmediately()) {
            this.find();
        }
        if ((searchActionProperty = this.finder.getSearchActionProperty()) != null) {
            searchActionProperty.set(e -> this.findButton.doClick());
        }
        if (this.viewSelectionPending) {
            this.viewSelectionPending = false;
            if (this.finder.isTreeShowingInitially()) {
                this.showTree();
            } else {
                this.showTable();
            }
        }
    }

    public T getPdo() {
        return (T)this.getFinder().getPdo();
    }

    public void setFinderVisible(boolean visible) {
        Parent view = this.finder.getView();
        view.setVisible(visible);
        view.setManaged(visible);
    }

    public boolean isFinderVisible() {
        return this.finder.getView().isVisible();
    }

    public void setSingleSelectMode(boolean singleSelectMode) {
        this.singleSelectMode = singleSelectMode;
        this.updateSelectMode();
        this.okButton.setVisible(singleSelectMode);
        this.okButton.setManaged(singleSelectMode);
        this.bindOkButton();
    }

    public boolean isSingleSelectMode() {
        return this.singleSelectMode;
    }

    public void setCreatePdoAllowed(boolean allowed) {
        this.newButton.setVisible(allowed);
        this.newButton.setManaged(allowed);
    }

    public boolean isCreatePdoAllowed() {
        return this.newButton.isVisible();
    }

    public void setTotals(ObservableList<T> totals) {
        if (totals != null && !totals.isEmpty()) {
            if (this.totalsView == null) {
                this.totalsView = this.finder.createTotalsTableView();
            }
            this.totalsView.setBoundTable(this.tableView);
            this.totalsView.setItems(totals);
            this.tablePane.setBottom(this.totalsView);
            this.totalsView.applyCss();
            this.totalsView.setPrefHeight((double)totals.size() * this.totalsView.getFixedCellSize() + 2.0);
        } else if (this.totalsView != null) {
            this.tablePane.setBottom(null);
            this.totalsView.setBoundTable(null);
        }
    }

    public ObservableList<T> getTotalsItems() {
        return this.totalsView == null ? null : this.totalsView.getItems();
    }

    public void updateTitle() {
        Stage stage = this.getStage();
        if (stage != null) {
            stage.setTitle(MessageFormat.format(this.resources.getString("Search {0}"), this.getPdo().getPlural()));
        }
    }

    public void find() {
        if (this.finder.validateForm()) {
            this.filterField.clear();
            if (this.finder.isSearchRunningInBackground()) {
                Rdc.bg((Node)this.getView(), this.finder::runSearch, result -> {
                    this.setItems((List<T>)result);
                    this.presetScrolling();
                }, ex -> Fx.error((Object)this.getView(), (String)ex.getLocalizedMessage(), (Throwable)ex));
            } else {
                Platform.runLater(() -> {
                    this.setItems(this.finder.runSearch());
                    this.presetScrolling();
                });
            }
            this.cancelButton.setText(this.resources.getString(Fx.isModal((Stage)this.getStage()) ? "cancel" : "close"));
        }
    }

    protected void presetScrolling() {
        if (this.items != null && !this.items.isEmpty()) {
            if (this.isTreeShown()) {
                this.treeView.getSelectionModel().clearSelection();
                if (this.finder.isScrollingToEnd()) {
                    this.treeView.scrollToCentered(this.treeView.getItems().size() - 1);
                } else {
                    this.treeView.scrollTo(0);
                }
            } else {
                this.tableView.getSelectionModel().clearSelection();
                if (this.finder.isScrollingToEnd()) {
                    this.tableView.scrollToCentered(this.tableView.getItems().size() - 1);
                } else {
                    this.tableView.scrollTo(0);
                }
            }
        }
    }

    protected ObservableList<T> filterViewablePdos(List<T> pdos) {
        ObservableList viewablePdos = FXCollections.observableArrayList();
        if (pdos != null) {
            for (PersistentDomainObject pdo : pdos) {
                if (pdo == null || !pdo.isViewAllowed()) continue;
                viewablePdos.add((Object)pdo);
            }
        }
        return viewablePdos;
    }

    public void setItems(List<T> pdos) {
        ObservableList<T> viewablePdos = this.filterViewablePdos(pdos);
        if (this.shiftDown && this.items != null && !this.items.isEmpty() && !viewablePdos.isEmpty()) {
            HashSet<T> itemSet = new HashSet<T>(this.items);
            ObservableList unsortedItems = FXCollections.observableArrayList((Collection)this.items.getSource());
            for (PersistentDomainObject pdo : viewablePdos) {
                if (itemSet.contains(pdo)) continue;
                unsortedItems.add((Object)pdo);
            }
            this.items = new SortedList(unsortedItems);
        } else {
            this.items = new SortedList(viewablePdos);
        }
        this.items.comparatorProperty().bind((ObservableValue)this.tableView.comparatorProperty());
        this.countLabel.setText(Integer.toString(this.items.size()));
        if (this.treeShown) {
            this.rootItem = new TreeItem();
            for (PersistentDomainObject item2 : this.items) {
                this.rootItem.getChildren().add(Rdc.createGuiProvider(item2).createTreeItem());
            }
            this.rootItem.setExpanded(true);
            this.treeView.setRoot(this.rootItem);
            this.treeView.setShowRoot(false);
            this.treeView.getSelectionModel().clearSelection();
            int firstIndex = this.tableView.getSelectionModel().getSelectedIndex();
            if (firstIndex >= 0) {
                this.tableView.getSelectionModel().getSelectedIndices().forEach(arg_0 -> ((MultipleSelectionModel)this.treeView.getSelectionModel()).select(arg_0));
                this.treeView.scrollToCentered(firstIndex);
            }
            this.treeViewInvalid = false;
            this.tableViewInvalid = true;
        } else {
            Node placeHolder;
            this.tableView.setItems(this.items);
            if (this.items.isEmpty() && (placeHolder = this.createPlaceHolder()) != null) {
                this.tableView.setPlaceholder(placeHolder);
            }
            this.tableView.getSelectionModel().clearSelection();
            Holder firstItemHolder = new Holder();
            this.treeView.getSelectionModel().getSelectedItems().forEach(item -> {
                if (item.getParent() == this.rootItem) {
                    this.tableView.getSelectionModel().select((Object)((PersistentDomainObject)item.getValue()));
                    if (firstItemHolder.get() == null) {
                        firstItemHolder.accept((Object)((PersistentDomainObject)item.getValue()));
                    }
                }
            });
            PersistentDomainObject firstItem = (PersistentDomainObject)firstItemHolder.get();
            if (firstItem != null) {
                this.tableView.scrollToCentered((Object)firstItem);
            }
            this.treeViewInvalid = true;
            this.tableViewInvalid = false;
        }
        if (this.getPdo().isNormTextProvided()) {
            this.filterField.setVisible(true);
            this.filterButton.setVisible(true);
        }
        this.itemsListener = null;
        if (!this.items.isEmpty()) {
            this.itemsListener = o -> this.setTotals(this.finder.createTotals((ObservableList<T>)this.items));
            this.items.addListener((InvalidationListener)new WeakInvalidationListener(this.itemsListener));
            this.itemsListener.invalidated(this.items);
        } else {
            this.setTotals(null);
        }
        this.updateSelectMode();
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    public void filterResult() {
        String text = this.filterField.getText();
        String filterText = StringNormalizer.getInstance().normalize(text);
        if (!StringHelper.isAllWhitespace((String)filterText)) {
            boolean inverted = text.startsWith("!") || text.startsWith("-");
            List filteredResult = this.getItems().stream().filter(p -> p.getNormText() != null && p.getNormText().contains(filterText) != inverted).collect(Collectors.toList());
            this.setItems((List<T>)FXCollections.observableArrayList(filteredResult));
        }
    }

    public ObservableList<T> getSelectedItems() {
        ObservableList selectedItems;
        if (this.createdPdo != null) {
            selectedItems = FXCollections.observableArrayList();
            selectedItems.add(this.createdPdo);
        } else if (this.treeShown) {
            selectedItems = FXCollections.observableArrayList();
            this.treeView.getSelectionModel().getSelectedItems().forEach(p -> {
                if (p.getParent() == this.rootItem) {
                    selectedItems.add((Object)((PersistentDomainObject)p.getValue()));
                }
            });
        } else {
            selectedItems = this.tableView.getSelectionModel().getSelectedItems();
        }
        return selectedItems;
    }

    public void clearSelection() {
        this.tableView.getSelectionModel().clearSelection();
        this.treeView.getSelectionModel().clearSelection();
    }

    public boolean isTreeShown() {
        return this.treeShown;
    }

    public void showTree() {
        if (!this.treeShown) {
            this.treeView.toFront();
            this.treeView.requestFocus();
            this.treeShown = true;
            this.treeButton.setGraphic(Fx.createGraphic((String)"table"));
            this.treeButton.setTooltip(new Tooltip(this.resources.getString("table")));
            if (this.treeViewInvalid) {
                this.setItems((List<T>)this.getItems());
            }
            this.bindOkButton();
        }
    }

    public FxTreeView<T> getTreeView() {
        this.showTree();
        return this.treeView;
    }

    public void showTable() {
        if (this.treeShown) {
            this.tablePane.toFront();
            this.tableView.requestFocus();
            this.treeShown = false;
            this.treeButton.setGraphic(Fx.createGraphic((String)"tree"));
            this.treeButton.setTooltip(new Tooltip(this.resources.getString("tree")));
            if (this.tableViewInvalid && this.treeView.getRoot() != null) {
                int index = 0;
                for (TreeItem item : this.treeView.getRoot().getChildren()) {
                    PersistentDomainObject listPdo = (PersistentDomainObject)this.items.get(index);
                    PersistentDomainObject treePdo = (PersistentDomainObject)item.getValue();
                    if (listPdo.getSerial() != treePdo.getSerial()) {
                        this.items.getSource().set(this.items.getSourceIndex(index), treePdo);
                    }
                    ++index;
                }
                this.setItems((List<T>)this.items);
            }
            this.bindOkButton();
        }
    }

    public FxTableView<T> getTableView() {
        this.showTable();
        return this.tableView;
    }

    public void cancel() {
        this.clearSelection();
        this.close();
    }

    public void close() {
        Stage stage = Fx.getStage((Node)this.getView());
        if (stage != null) {
            stage.close();
        }
    }

    public void createPdo() {
        PersistentDomainObject nPdo = this.getPdo().on();
        if (this.getPdo().isUniqueDomainKeyProvided()) {
            nPdo.setUniqueDomainKey(this.getPdo().getUniqueDomainKey());
        }
        Rdc.displayCrudStage(nPdo, true, Modality.APPLICATION_MODAL, (Window)this.getStage(), updatedPdo -> {
            if (updatedPdo != null && !updatedPdo.isNew()) {
                this.createdPdo = updatedPdo;
                this.close();
            }
        });
    }

    @FXML
    private void initialize() {
        this.treeButton.setGraphic(Fx.createGraphic((String)"tree"));
        this.treeButton.setTooltip(new Tooltip(this.resources.getString("tree")));
        this.treeButton.setOnAction(e -> {
            if (this.treeShown) {
                this.showTable();
            } else {
                this.showTree();
            }
        });
        this.filterButton.setGraphic(Fx.createGraphic((String)"filter"));
        this.filterButton.setOnAction(e -> this.filterResult());
        this.filterField.setOnAction(e -> this.filterButton.doClick());
        this.searchIcon = Fx.createGraphic((String)"search");
        this.searchPlusIcon = Fx.createGraphic((String)"add");
        this.findButton.setGraphic(this.searchIcon);
        this.findButton.setOnMouseEntered(event -> {
            this.mouseOverFindButton = true;
            this.updateFindButton();
        });
        this.findButton.setOnMouseExited(event -> {
            this.mouseOverFindButton = false;
            this.updateFindButton();
        });
        this.findButton.setOnAction(e -> this.find());
        this.findButton.setOnMousePressed(event -> {
            if (this.shiftDown) {
                this.findButton.doClick();
            }
        });
        this.newButton.setGraphic(Fx.createGraphic((String)"new"));
        this.newButton.setOnAction(e -> this.createPdo());
        this.okButton.setGraphic(Fx.createGraphic((String)"ok"));
        this.okButton.setOnAction(e -> this.close());
        this.cancelButton.setGraphic(Fx.createGraphic((String)"close"));
        this.cancelButton.setOnAction(e -> this.cancel());
        this.cancelButton.setCancelButton(true);
        this.tablePane = (FxBorderPane)Fx.create(BorderPane.class);
    }

    public void configure() {
        this.getView().addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (!(event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShiftDown() || event.isShortcutDown() || event.getCode() != KeyCode.ESCAPE || !Fx.isModal((Stage)this.getStage()))) {
                this.cancel();
            }
            this.toggleShiftKey(event.isShiftDown());
        });
        this.getView().addEventFilter(KeyEvent.KEY_RELEASED, event -> this.toggleShiftKey(event.isShiftDown()));
    }

    protected void bindOkButton() {
        this.okButton.disableProperty().unbind();
        if (this.okButton.isVisible()) {
            if (this.treeShown) {
                this.okButton.disableProperty().bind((ObservableValue)this.treeView.getSelectionModel().selectedItemProperty().isNull().or((ObservableBooleanValue)this.wrongTypeSelected));
            } else {
                this.okButton.disableProperty().bind((ObservableValue)this.tableView.getSelectionModel().selectedItemProperty().isNull());
            }
        }
    }

    protected boolean isCrudShown() {
        Stage stage;
        if (this.pdoCrud != null && (stage = this.pdoCrud.getStage()) != null && stage.isShowing() && stage.getOwner() == this.getStage()) {
            return true;
        }
        this.pdoCrud = null;
        return false;
    }

    protected Node createPlaceHolder() {
        Label placeHolder = (Label)Fx.create(Label.class);
        String text = Objects.requireNonNullElseGet(this.noDataMessage, () -> MessageFormat.format(this.resources.getString("no {0} found"), this.getPdo().getPlural()));
        placeHolder.setText(text);
        return placeHolder;
    }

    private void updateSelectMode() {
        SelectionMode selectionMode = this.singleSelectMode ? SelectionMode.SINGLE : SelectionMode.MULTIPLE;
        this.tableView.getSelectionModel().setSelectionMode(selectionMode);
        this.treeView.getSelectionModel().setSelectionMode(selectionMode);
    }

    private void toggleShiftKey(boolean shiftDown) {
        if (this.shiftDown != shiftDown) {
            this.shiftDown = shiftDown;
            if (this.mouseOverFindButton || !shiftDown) {
                this.updateFindButton();
            }
        }
    }

    private void updateFindButton() {
        Node icon;
        Node node = icon = this.shiftDown ? this.searchPlusIcon : this.searchIcon;
        if (icon != this.findButton.getGraphic()) {
            this.findButton.setGraphic(icon);
        }
    }
}

