/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.translate;

import java.util.List;
import javafx.collections.ObservableList;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.rdc.Rdc;
import org.tentackle.fx.rdc.RdcRuntimeException;
import org.tentackle.fx.table.TableConfigurationProvider;
import org.tentackle.fx.translate.ObservableListTranslator;
import org.tentackle.log.Logger;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;

@ValueTranslatorService(modelClass=List.class, viewClass=ObservableList.class)
public class PdoObservableListTranslator<T extends PersistentDomainObject<T>, C extends List<T>>
extends ObservableListTranslator<T, C> {
    private static final Logger LOG = Logger.get(PdoObservableListTranslator.class);

    public PdoObservableListTranslator(FxComponent component) {
        super(component);
    }

    protected TableConfigurationProvider<T> createTableConfigurationProvider(Class<T> elemClass) {
        if (PersistentDomainObject.class.isAssignableFrom(elemClass)) {
            try {
                return Rdc.createGuiProvider(Pdo.create(elemClass));
            }
            catch (RdcRuntimeException | PdoRuntimeException px) {
                LOG.warning("no GuiProvider for " + String.valueOf(elemClass) + " (" + px.getMessage() + ") -> fallback to default table configuration provider");
            }
        }
        return super.createTableConfigurationProvider(elemClass);
    }
}

