/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableCell;
import javafx.scene.input.MouseEvent;
import org.tentackle.fx.rdc.PdoContextMenuFactory;
import org.tentackle.pdo.PersistentDomainObject;

public class PdoTableCell<S, T extends PersistentDomainObject<T>>
extends TableCell<S, T> {
    private ContextMenu contextMenu;

    public PdoTableCell() {
        this.addEventHandler(MouseEvent.ANY, event -> {
            if (event.isPopupTrigger()) {
                this.showContextMenu((MouseEvent)event);
            }
        });
    }

    public void updateItem(T pdo, boolean empty) {
        super.updateItem(pdo, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setText(pdo.toString());
        }
    }

    public void showContextMenu(MouseEvent event) {
        if (this.contextMenu != null) {
            this.contextMenu.hide();
        }
        this.contextMenu = PdoContextMenuFactory.getInstance().create(this);
        if (this.contextMenu != null) {
            event.consume();
            this.contextMenu.setOnHidden(e -> {
                this.contextMenu = null;
            });
            this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
        }
    }
}

