/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.Service;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.pdo.PdoRuntimeException;
import org.tentackle.pdo.PersistentDomainObject;
import org.tentackle.reflect.ClassMapper;
import org.tentackle.reflect.DefaultClassMapper;

@Service(value=GuiProviderFactory.class)
public class DefaultGuiProviderFactory
implements GuiProviderFactory {
    private final ConcurrentHashMap<Class, Constructor> serviceMap = new ConcurrentHashMap();
    private final ClassMapper guiClassMapper = new DefaultClassMapper("FX GUI-provider", GuiProvider.class);

    @Override
    public <T extends PersistentDomainObject<T>> GuiProvider<T> createGuiProvider(T pdo) {
        Class pdoClass = pdo.getEffectiveClass();
        Constructor<?> constructor = this.serviceMap.get(pdoClass);
        if (constructor == null) {
            try {
                Class serviceClass = this.guiClassMapper.mapLenient(pdoClass);
                for (Constructor<?> con : serviceClass.getConstructors()) {
                    Class<?>[] params = con.getParameterTypes();
                    if (params.length != 1 || !pdoClass.isAssignableFrom(params[0])) continue;
                    constructor = con;
                    this.serviceMap.put(pdoClass, constructor);
                    break;
                }
                if (constructor == null) {
                    throw new PdoRuntimeException("no matching constructor found for " + serviceClass.getName() + "(" + pdoClass.getName() + ")");
                }
            }
            catch (ClassNotFoundException ex) {
                throw new PdoRuntimeException("cannot load GUI service class for " + pdoClass.getName(), (Throwable)ex);
            }
        }
        try {
            return (GuiProvider)constructor.newInstance(pdo);
        }
        catch (Exception e) {
            throw new PdoRuntimeException("cannot instantiate GUI service object for " + pdoClass.getName(), (Throwable)e);
        }
    }
}

