/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.table;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.print.PageLayout;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.transform.Scale;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.tentackle.common.Timestamp;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxLabel;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.container.FxHBox;
import org.tentackle.fx.rdc.RdcFxRdcBundle;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.FxTableColumn;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TotalsTableView;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.misc.Duration;
import org.tentackle.misc.FormatHelper;
import org.tentackle.session.AbstractSessionTask;
import org.tentackle.session.ModificationTracker;
import org.tentackle.task.Task;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@FxControllerService(binding=FxControllerService.BINDING.NO)
public class TablePrinter
extends AbstractFxController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TablePrinter.class);
    private static final String STYLE_TITLE = "title";
    private static final String STYLE_BOTTOMLINE = "bottomline";
    private static final String STYLE_TOTALS = "totals";
    private ResourceBundle resources;
    private int pageCount;
    @FXML
    private FxLabel titleLabel;
    @FXML
    private FxTableView<?> tableView;
    @FXML
    private FxHBox bottomLine;
    @FXML
    private FxLabel dateLabel;
    @FXML
    private FxLabel pageLabel;
    private Duration jobDuration;
    private int rowCount;
    private int totalsRowCount;
    private volatile int rowOffset;
    private volatile boolean terminationRequested;

    public static void print(FxTableView<?> fxTableView, String string, PrinterJob printerJob) {
        Stage stage = Fx.createStage((Modality)Modality.APPLICATION_MODAL);
        TablePrinter tablePrinter = (TablePrinter)Fx.load(TablePrinter.class);
        Scene scene = new Scene(tablePrinter.getView());
        stage.setScene(scene);
        stage.setTitle(RdcFxRdcBundle.getString("Printing..."));
        String string2 = string == null ? fxTableView.getConfiguration().getName() : string;
        if (string2 != null) {
            printerJob.getJobSettings().setJobName(string2);
        }
        stage.setOnShown(windowEvent -> Platform.runLater(() -> tablePrinter.print(fxTableView, string2, printerJob, printerJob.getJobSettings().getPageLayout(), stage)));
        stage.setOnCloseRequest(windowEvent -> {
            if (Fx.question((String)RdcFxRdcBundle.getString("cancel print job?"), (boolean)false)) {
                tablePrinter.terminationRequested = true;
            } else {
                windowEvent.consume();
            }
        });
        stage.showAndWait();
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.resources = resourceBundle;
        this.titleLabel.getStyleClass().add((Object)STYLE_TITLE);
        this.bottomLine.getStyleClass().add((Object)STYLE_BOTTOMLINE);
        this.pageLabel.getStyleClass().add((Object)STYLE_BOTTOMLINE);
        this.dateLabel.getStyleClass().add((Object)STYLE_BOTTOMLINE);
        this.jobDuration = new Duration();
    }

    private void print(FxTableView<?> fxTableView, String string, PrinterJob printerJob, PageLayout pageLayout, Stage stage) {
        ObservableList observableList;
        LOGGER.fine("table print job {0}", new Object[]{printerJob});
        this.dateLabel.setText(FormatHelper.formatShortTimestamp((Date)new Timestamp()));
        double d = 0.0;
        this.tableView.getColumns().clear();
        this.tableView.setConfiguration(fxTableView.getConfiguration());
        for (TableColumn tableColumn : fxTableView.getColumns()) {
            if (!tableColumn.isVisible()) continue;
            TableColumnConfiguration tableColumnConfiguration = tableColumn instanceof FxTableColumn ? ((FxTableColumn)tableColumn).getConfiguration() : null;
            FxTableColumn fxTableColumn = new FxTableColumn(tableColumnConfiguration, tableColumn.getText());
            fxTableColumn.setCellValueFactory(tableColumn.getCellValueFactory());
            fxTableColumn.setCellFactory(new PrintCellFactory(tableColumn.getCellFactory()));
            fxTableColumn.setMinWidth(tableColumn.getWidth());
            fxTableColumn.setMaxWidth(tableColumn.getWidth());
            this.tableView.getColumns().add((Object)fxTableColumn);
            d += tableColumn.getWidth();
        }
        double d2 = pageLayout.getPrintableWidth();
        double d3 = pageLayout.getPrintableHeight();
        double d4 = 1.0;
        if (d2 < d) {
            d4 = d2 / d;
            d = d2 / d4;
        }
        this.tableView.setMinWidth(d - 1.0);
        this.tableView.setMaxWidth(d - 1.0);
        this.titleLabel.setText(string);
        this.updatePageLabel(1);
        this.getView().layout();
        double d5 = d3 / d4 - this.titleLabel.getHeight() - this.bottomLine.getHeight();
        this.tableView.setMinHeight(d5);
        this.tableView.setMaxHeight(d5);
        this.getView().getTransforms().add((Object)new Scale(d4, d4));
        TotalsTableView totalsTableView = fxTableView.getTotalsTableView();
        if (totalsTableView != null) {
            observableList = FXCollections.observableArrayList((Collection)fxTableView.getItems());
            observableList.addAll((Collection)totalsTableView.getItems());
            this.totalsRowCount = totalsTableView.getItems().size();
        } else {
            observableList = fxTableView.getItems();
            this.totalsRowCount = 0;
        }
        this.rowCount = observableList.size();
        ModificationTracker.getInstance().addTask((Task)new PrinterTask(observableList, printerJob, pageLayout, stage));
    }

    private void updatePageLabel(int n) {
        this.pageLabel.setText(MessageFormat.format(this.resources.getString("page {0} of {1}"), n, this.pageCount));
    }

    private int getVisibleRowCount() {
        VirtualFlow virtualFlow = (VirtualFlow)((TableViewSkin)this.tableView.getSkin()).getChildren().get(1);
        int n = 0;
        IndexedCell indexedCell = virtualFlow.getFirstVisibleCell();
        if (indexedCell != null) {
            n = indexedCell.getIndex();
        }
        indexedCell = virtualFlow.getLastVisibleCell();
        int n2 = -1;
        if (indexedCell != null) {
            int n3 = indexedCell.getIndex();
            n2 = n3 - n;
            if (n3 >= virtualFlow.getCellCount() - 1) {
                this.tableView.scrollTo(n3);
                indexedCell = virtualFlow.getFirstVisibleCell();
                if (indexedCell != null && indexedCell.getIndex() == n) {
                    ++n2;
                } else {
                    this.tableView.scrollTo(n);
                }
            }
        }
        return n2;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class PrinterTask
    extends AbstractSessionTask {
        private final ObservableList items;
        private final PrinterJob job;
        private final PageLayout pageLayout;
        private final Stage stage;
        private volatile int printableRows;

        private PrinterTask(ObservableList observableList, PrinterJob printerJob, PageLayout pageLayout, Stage stage) {
            this.items = observableList;
            this.job = printerJob;
            this.pageLayout = pageLayout;
            this.stage = stage;
        }

        private void setPrintableRows(int n) {
            this.printableRows = n;
        }

        public void run() {
            ArrayList<PageInfo> arrayList = new ArrayList<PageInfo>();
            int n = this.items.size();
            TablePrinter.this.rowOffset = 0;
            while (TablePrinter.this.rowOffset < n && !TablePrinter.this.terminationRequested) {
                Fx.runAndWait(() -> {
                    TablePrinter.this.tableView.setItems(FXCollections.observableList((List)this.items.subList(TablePrinter.this.rowOffset, n)));
                    TablePrinter.this.getView().layout();
                });
                Fx.runAndWait(() -> this.setPrintableRows(TablePrinter.this.getVisibleRowCount()));
                if (this.printableRows <= 0) {
                    Platform.runLater(() -> {
                        this.job.cancelJob();
                        Fx.error((String)TablePrinter.this.resources.getString("no printable area"));
                        this.stage.close();
                    });
                    return;
                }
                PageInfo pageInfo = new PageInfo(TablePrinter.this.rowOffset, this.printableRows);
                arrayList.add(pageInfo);
                Platform.runLater(() -> this.stage.setTitle(MessageFormat.format(TablePrinter.this.resources.getString("preparing page {0}"), arrayList.size())));
                TablePrinter.this.rowOffset += this.printableRows;
                LOGGER.fine("page {0}: {1}", new Object[]{arrayList.size(), pageInfo});
                this.getSession().setAlive(true);
            }
            if (TablePrinter.this.terminationRequested) {
                LOGGER.info("job \"{0}\" canceled by user", new Object[]{TablePrinter.this.titleLabel.getText()});
            } else {
                TablePrinter.this.pageCount = arrayList.size();
                Fx.runAndWait(() -> {
                    if (TablePrinter.this.pageCount == 0) {
                        Fx.info((String)TablePrinter.this.resources.getString("no pages to print"));
                        this.job.cancelJob();
                    } else {
                        int n = 1;
                        for (PageInfo pageInfo : arrayList) {
                            TablePrinter.this.rowOffset = pageInfo.rowStart;
                            TablePrinter.this.tableView.setItems(FXCollections.observableList((List)this.items.subList(TablePrinter.this.rowOffset, TablePrinter.this.rowOffset + pageInfo.rowCount)));
                            TablePrinter.this.tableView.getSelectionModel().clearSelection();
                            this.stage.setTitle(MessageFormat.format(TablePrinter.this.resources.getString("printing page {0}/{1}"), n, arrayList.size()));
                            TablePrinter.this.updatePageLabel(n++);
                            this.job.printPage(this.pageLayout, (Node)TablePrinter.this.getView());
                            if (TablePrinter.this.terminationRequested) break;
                            this.getSession().setAlive(true);
                        }
                        if (TablePrinter.this.terminationRequested) {
                            this.job.cancelJob();
                            LOGGER.info("printing job \"{0}\" canceled by user", new Object[]{TablePrinter.this.titleLabel.getText()});
                        } else {
                            this.job.endJob();
                            TablePrinter.this.jobDuration.end();
                            LOGGER.info("job \"{0}\", {1} pages printed, {2} s", new Object[]{TablePrinter.this.titleLabel.getText(), arrayList.size(), TablePrinter.this.jobDuration.secondsToString()});
                        }
                    }
                    this.stage.close();
                });
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class PrintCellFactory<S, T>
    implements Callback<TableColumn<S, T>, TableCell<S, T>> {
        private final Callback<TableColumn<S, T>, TableCell<S, T>> orgCellFactory;

        public PrintCellFactory(Callback<TableColumn<S, T>, TableCell<S, T>> callback) {
            this.orgCellFactory = callback;
        }

        public TableCell<S, T> call(TableColumn<S, T> tableColumn) {
            Object object = (TableCell)this.orgCellFactory.call(tableColumn);
            FxTableColumn fxTableColumn = (FxTableColumn)tableColumn;
            final TableColumnConfiguration tableColumnConfiguration = fxTableColumn.getConfiguration();
            if (TablePrinter.this.totalsRowCount > 0 && tableColumnConfiguration != null) {
                object = new FxTableCell<S, T>(tableColumnConfiguration){

                    /*
                     * Enabled aggressive block sorting
                     */
                    protected void updateItem(T t, boolean bl) {
                        block4: {
                            block3: {
                                int n = TablePrinter.this.rowOffset + this.getIndex();
                                if (n < TablePrinter.this.rowCount - TablePrinter.this.totalsRowCount) break block3;
                                if (tableColumnConfiguration.isSummable() && n < TablePrinter.this.rowCount) {
                                    if (!this.getStyleClass().contains((Object)TablePrinter.STYLE_TOTALS)) {
                                        this.getStyleClass().add((Object)TablePrinter.STYLE_TOTALS);
                                    }
                                    break block4;
                                } else {
                                    this.getStyleClass().remove((Object)TablePrinter.STYLE_TOTALS);
                                    this.setText(null);
                                    this.setGraphic(null);
                                    return;
                                }
                            }
                            this.getStyleClass().remove((Object)TablePrinter.STYLE_TOTALS);
                        }
                        super.updateItem(t, bl);
                    }
                };
            }
            return object;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PageInfo {
        private final int rowStart;
        private final int rowCount;

        public PageInfo(int n, int n2) {
            this.rowStart = n;
            this.rowCount = n2;
        }

        public String toString() {
            return "print " + this.rowCount + " rows starting at row " + this.rowStart;
        }
    }
}

