/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import org.tentackle.fx.rdc.GuiProvider;
import org.tentackle.fx.rdc.GuiProviderFactory;
import org.tentackle.pdo.PersistentDomainObject;

public class PdoTreeItem<T extends PersistentDomainObject<T>>
extends TreeItem<T> {
    private T pdo;
    private GuiProvider<T> provider;
    private boolean childrenLoaded;

    public PdoTreeItem(T pdo) {
        super(pdo);
        this.pdo = pdo;
    }

    public T getPdo() {
        return this.pdo;
    }

    public void setPdo(T pdo) {
        this.setValue(pdo);
        this.pdo = pdo;
        this.provider = null;
    }

    public boolean isLeaf() {
        return !this.getGuiProvider().providesTreeChildObjects();
    }

    public ObservableList<TreeItem<T>> getChildren() {
        if (!this.childrenLoaded) {
            this.childrenLoaded = true;
            ArrayList childList = new ArrayList();
            PdoTreeItem parentItem = this.getParentPdoItem();
            for (PersistentDomainObject<?> child : this.getGuiProvider().getTreeChildObjects(parentItem == null ? null : (PersistentDomainObject)parentItem.getPdo())) {
                TreeItem<PersistentDomainObject<?>> treeItem = GuiProviderFactory.getInstance().createGuiProvider(child).createTreeItem();
                childList.add(treeItem);
            }
            super.getChildren().setAll(childList);
        }
        return super.getChildren();
    }

    public <P extends PersistentDomainObject<P>> PdoTreeItem<P> getParentPdoItem() {
        TreeItem parent = this.getParent();
        return parent instanceof PdoTreeItem ? (PdoTreeItem)parent : null;
    }

    public <P extends PersistentDomainObject<P>> P getParentPdo(Class<P> parentPdoClass) {
        T parentPdo;
        TreeItem parent = this.getParent();
        if (parent instanceof PdoTreeItem && (parentPdo = ((PdoTreeItem)parent).getPdo()) != null && parentPdoClass.isAssignableFrom(parentPdo.getClass())) {
            return (P)parentPdo;
        }
        return null;
    }

    public GuiProvider<T> getGuiProvider() {
        if (this.provider == null) {
            this.provider = GuiProviderFactory.getInstance().createGuiProvider(this.pdo);
        }
        return this.provider;
    }

    public void expand() {
        if (this.isExpanded()) {
            this.collapse();
        }
        this.expand(new HashSet());
    }

    public void collapse() {
        this.collapse(new HashSet());
    }

    protected void expand(Set<T> pdoSet) {
        if (this.getGuiProvider().providesTreeChildObjects() && pdoSet.add(this.getPdo())) {
            this.setExpanded(true);
            for (TreeItem childItem : this.getChildren()) {
                ((PdoTreeItem)childItem).expand(pdoSet);
            }
        }
    }

    protected void collapse(Set<T> pdoSet) {
        if (pdoSet.add(this.getPdo())) {
            this.setExpanded(false);
            for (TreeItem childItem : this.getChildren()) {
                ((PdoTreeItem)childItem).collapse(pdoSet);
            }
        }
    }
}

