/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.component.delegate;

import java.util.Collection;
import java.util.function.Supplier;
import javafx.collections.ObservableList;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.pdo.DomainContext;
import org.tentackle.pdo.Pdo;
import org.tentackle.pdo.PersistentDomainObject;

public class RdcBoxDelegateImpl {
    private final FxComponent component;
    private final Supplier<ObservableList> itemSupplier;
    private long lastModificationCount;
    private PersistentDomainObject proxy;

    public RdcBoxDelegateImpl(FxComponent component, Supplier<ObservableList> itemSupplier) {
        this.component = component;
        this.itemSupplier = itemSupplier;
    }

    public void prepareSetType(Class<?> type) {
        this.lastModificationCount = PersistentDomainObject.class.isAssignableFrom(type) ? -1L : 0L;
        this.proxy = null;
    }

    public void prepareSetViewValue() {
        if (this.lastModificationCount != 0L) {
            boolean loadItems = false;
            if (this.proxy == null) {
                FxComponentBinding binding = this.component.getBinding();
                DomainContext context = (DomainContext)binding.getBinder().getBindingProperty(DomainContext.class);
                if (context != null) {
                    this.proxy = Pdo.create((Class)this.component.getType(), (DomainContext)context);
                    loadItems = true;
                }
            } else {
                long modificationCount = this.proxy.getModificationCount();
                if (modificationCount != this.lastModificationCount) {
                    this.lastModificationCount = modificationCount;
                    loadItems = true;
                }
            }
            if (loadItems) {
                if (this.lastModificationCount == -1L) {
                    this.lastModificationCount = this.proxy.getModificationCount();
                }
                ObservableList items = this.itemSupplier.get();
                items.setAll((Collection)this.proxy.selectAllCached());
            }
        }
    }
}

