/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.login;

import java.awt.Toolkit;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tentackle.app.AbstractApplication;
import org.tentackle.fx.AbstractFxController;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.component.FxButton;
import org.tentackle.fx.component.FxPasswordField;
import org.tentackle.fx.component.FxTextField;
import org.tentackle.fx.rdc.app.DesktopApplication;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.session.SessionInfo;

@FxControllerService(binding=FxControllerService.BINDING.NO)
public class Login
extends AbstractFxController {
    private static final Logger LOGGER = LoggerFactory.getLogger(Login.class);
    private ResourceBundle resources;
    private SessionInfo sessionInfo;
    private boolean autoLogin;
    @FXML
    private FxTextField usernameField;
    @FXML
    private FxPasswordField passwordField;
    @FXML
    private Label messageLabel;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private FxButton loginButton;
    @FXML
    private FxButton cancelButton;

    public void initialize(URL location, ResourceBundle resources) {
        this.resources = resources;
        this.progressBar.setVisible(false);
        this.setCapsLockMessage(this.isCapsLock());
        this.cancelButton.setOnAction(e -> this.cancel());
        this.cancelButton.setGraphic((Node)Fx.createImageView((String)"close"));
        this.loginButton.setOnAction(e -> this.login());
        this.loginButton.setGraphic((Node)Fx.createImageView((String)"ok"));
        this.usernameField.setAutoSelect(true);
        this.passwordField.setOnAction(e -> this.login());
        this.passwordField.setAutoSelect(true);
    }

    public void configure() {
        this.getView().addEventFilter(KeyEvent.KEY_RELEASED, event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                this.cancel();
            }
            if (event.getCode() == KeyCode.CAPS) {
                Platform.runLater(() -> this.setCapsLockMessage(this.isCapsLock()));
            }
        });
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
        this.usernameField.setText(sessionInfo.getUserName());
        this.passwordField.setText(sessionInfo.getPassword() == null ? null : new String(sessionInfo.getPassword()));
    }

    public void autoLogin() {
        this.autoLogin = true;
        Platform.runLater(() -> {
            this.usernameField.setEditable(false);
            this.passwordField.setEditable(false);
            this.login();
        });
    }

    private void login() {
        if (this.progressBar.getProgress() <= 0.0) {
            this.sessionInfo.setUserName(this.usernameField.getText());
            String pwd = this.passwordField.getText();
            this.sessionInfo.setPassword(pwd == null ? null : pwd.toCharArray());
            this.setProgress(0.01);
            ((DesktopApplication)AbstractApplication.getRunningApplication()).doLogin(this.getView(), this.sessionInfo);
        } else {
            LOGGER.warning("login already in progress...", new Object[0]);
        }
    }

    private void cancel() {
        Fx.getStage((Node)this.getView()).hide();
    }

    public void setProgress(double value) {
        if (value <= 0.0 && !this.autoLogin) {
            this.progressBar.setVisible(false);
            this.progressBar.setProgress(0.0);
            this.loginButton.setDisable(false);
            this.cancelButton.setDisable(false);
            this.usernameField.setChangeable(true);
            this.passwordField.setChangeable(true);
        } else {
            this.progressBar.setVisible(true);
            this.progressBar.setProgress(value);
            this.loginButton.setDisable(true);
            this.cancelButton.setDisable(true);
            this.usernameField.setChangeable(false);
            this.passwordField.setChangeable(false);
        }
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    private void setCapsLockMessage(boolean capsLock) {
        if (capsLock) {
            this.setMessage(this.resources.getString("CAPS LOCK!"));
        } else {
            this.setMessage(null);
        }
    }

    private boolean isCapsLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(20);
    }
}

