/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.rdc.table;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.prefs.BackingStoreException;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxFxBundle;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.rdc.table.TableUtilities;
import org.tentackle.log.Logger;
import org.tentackle.log.LoggerFactory;
import org.tentackle.prefs.PersistedPreferences;
import org.tentackle.prefs.PersistedPreferencesFactory;

public class TablePopup<S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TablePopup.class);
    private static final String EXCEL_EXTENSION = ".xls";
    private static final String LAST_EXCEL_PREFIX = "/_lastExcelNames_";
    private static final String EXCEL_KEY = "path";
    private static final String XML_EXTENSION = ".xml";
    private static final String LAST_XML_PREFIX = "/_lastXmlNames_";
    private static final String XML_KEY = "path";
    private final FxTableView<S> table;
    private final String preferencesSuffix;
    private final boolean noViewSize;
    private String title;
    private boolean columnMenuEnabled = true;

    public TablePopup(FxTableView<S> table, String preferencesSuffix, boolean noViewSize, String title) {
        this.table = table;
        this.preferencesSuffix = preferencesSuffix;
        this.noViewSize = noViewSize;
        this.title = title;
        ContextMenu menu = this.createContextMenu();
        table.setContextMenu(menu);
        for (TableColumn column : table.getColumns()) {
            column.setContextMenu(menu);
        }
    }

    public FxTableView<S> getTable() {
        return this.table;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPreferencesSuffix() {
        return this.preferencesSuffix;
    }

    public boolean isColumnMenuEnabled() {
        return this.columnMenuEnabled;
    }

    public void setColumnMenuEnabled(boolean columnMenuEnabled) {
        this.columnMenuEnabled = columnMenuEnabled;
    }

    public ContextMenu createContextMenu() {
        Menu columnMenu;
        ContextMenu menu = new ContextMenu();
        ObservableList columns = this.table.getColumns();
        if (this.columnMenuEnabled) {
            columnMenu = new Menu();
            columnMenu.setText(FxFxBundle.getString((String)"COLUMNS..."));
            menu.getItems().add((Object)columnMenu);
        } else {
            columnMenu = null;
        }
        MenuItem autoWidthItem = new MenuItem();
        autoWidthItem.setText(FxFxBundle.getString((String)"AUTO WIDTH"));
        autoWidthItem.setOnAction(e -> this.autoWidth());
        menu.getItems().add((Object)autoWidthItem);
        MenuItem printItem = new MenuItem();
        printItem.setText(FxFxBundle.getString((String)"PRINT"));
        printItem.setOnAction(e -> this.print());
        menu.getItems().add((Object)printItem);
        MenuItem excelItem = new MenuItem();
        excelItem.setText(FxFxBundle.getString((String)"EXPORT TO EXCEL"));
        excelItem.setOnAction(e -> this.toSpreadsheet(false));
        menu.getItems().add((Object)excelItem);
        MenuItem selectedExcelItem = new MenuItem();
        selectedExcelItem.setText(FxFxBundle.getString((String)"EXPORT TO EXCEL (ONLY SELECTED)"));
        selectedExcelItem.setOnAction(e -> this.toSpreadsheet(true));
        menu.getItems().add((Object)selectedExcelItem);
        MenuItem xmlItem = new MenuItem();
        xmlItem.setText(FxFxBundle.getString((String)"EXPORT TO XML"));
        xmlItem.setOnAction(e -> this.toXml(false));
        menu.getItems().add((Object)xmlItem);
        MenuItem selectedXmlItem = new MenuItem();
        selectedXmlItem.setText(FxFxBundle.getString((String)"EXPORT TO XML (ONLY SELECTED)"));
        selectedXmlItem.setOnAction(e -> this.toXml(true));
        menu.getItems().add((Object)selectedXmlItem);
        if (PersistedPreferencesFactory.getInstance().isSystemOnly()) {
            if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                MenuItem saveItem = new MenuItem();
                saveItem.setText(FxFxBundle.getString((String)"SAVE SYSTEM PREFERENCES"));
                saveItem.setOnAction(e -> this.savePreferences(true));
                menu.getItems().add((Object)saveItem);
            }
            MenuItem restoreItem = new MenuItem();
            restoreItem.setText(FxFxBundle.getString((String)"LOAD SYSTEM PREFERENCES"));
            restoreItem.setOnAction(e -> this.loadPreferences(true));
            menu.getItems().add((Object)restoreItem);
        } else {
            if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                MenuItem saveItem = new MenuItem();
                saveItem.setText(FxFxBundle.getString((String)"SAVE USER PREFERENCES"));
                saveItem.setOnAction(e -> this.savePreferences(false));
                menu.getItems().add((Object)saveItem);
            }
            MenuItem restoreItem = new MenuItem();
            restoreItem.setText(FxFxBundle.getString((String)"LOAD USER PREFERENCES"));
            restoreItem.setOnAction(e -> this.loadPreferences(false));
            menu.getItems().add((Object)restoreItem);
            MenuItem restoreSysItem = new MenuItem();
            restoreSysItem.setText(FxFxBundle.getString((String)"LOAD SYSTEM PREFERENCES"));
            restoreSysItem.setOnAction(e -> this.loadPreferences(true));
            menu.getItems().add((Object)restoreSysItem);
        }
        menu.setOnShowing(event -> {
            if (columnMenu != null) {
                columnMenu.getItems().clear();
                boolean allVisible = true;
                boolean allInvisible = true;
                for (TableColumn column : columns) {
                    CheckMenuItem item = new CheckMenuItem(column.getText());
                    item.setSelected(column.isVisible());
                    if (column.isVisible()) {
                        allInvisible = false;
                    } else {
                        allVisible = false;
                    }
                    item.setOnAction(e -> column.setVisible(item.isSelected()));
                    columnMenu.getItems().add((Object)item);
                }
                if (!allVisible) {
                    MenuItem showAllItem = new MenuItem(FxFxBundle.getString((String)"SHOW ALL"));
                    showAllItem.setOnAction(e -> {
                        for (TableColumn column : columns) {
                            column.setVisible(true);
                        }
                    });
                    columnMenu.getItems().add((Object)showAllItem);
                }
                if (!allInvisible) {
                    MenuItem hideAllItem = new MenuItem(FxFxBundle.getString((String)"HIDE ALL"));
                    hideAllItem.setOnAction(e -> {
                        for (TableColumn column : columns) {
                            column.setVisible(false);
                        }
                    });
                    columnMenu.getItems().add((Object)hideAllItem);
                }
            }
        });
        return menu;
    }

    public void autoWidth() {
        FxUtilities.getInstance().resizeColumnsToFitContent(this.table);
    }

    public void print() {
        TableUtilities.getInstance().print(this.table, this.title);
    }

    public void toSpreadsheet(boolean onlySelected) {
        try {
            String prefName = StringHelper.trimRight((String)(LAST_EXCEL_PREFIX + this.table.getConfiguration().getName()), (char)'/');
            PersistedPreferences prefs = PersistedPreferences.userRoot().node(prefName);
            String lastName = prefs.get("path", null);
            FileChooser fc = new FileChooser();
            if (lastName != null) {
                fc.setInitialFileName(lastName);
            }
            fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(FxFxBundle.getString((String)"EXCEL FILE"), new String[]{EXCEL_EXTENSION})});
            File selectedFile = fc.showSaveDialog((Window)Fx.getStage(this.table));
            if (selectedFile != null) {
                if (!selectedFile.getName().toLowerCase().endsWith(EXCEL_EXTENSION)) {
                    selectedFile = new File(selectedFile.getPath() + EXCEL_EXTENSION);
                }
                TableUtilities.getInstance().toSpreadsheet(this.table, selectedFile, onlySelected);
                if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                    prefs.put("path", selectedFile.getAbsolutePath());
                    prefs.flush();
                }
            }
            if (selectedFile != null) {
                File excelFile = selectedFile;
                new Thread(() -> {
                    try {
                        LOGGER.info("launching EDIT action for {0}", new Object[]{excelFile});
                        Desktop.getDesktop().edit(excelFile);
                    }
                    catch (IOException | UnsupportedOperationException ex) {
                        LOGGER.info("{0} -> trying OPEN action for {1}", new Object[]{ex.getMessage(), excelFile});
                        try {
                            Desktop.getDesktop().open(excelFile);
                            LOGGER.info("success!", new Object[0]);
                        }
                        catch (IOException ex2) {
                            LOGGER.severe("cannot open spreadsheet file", (Throwable)ex2);
                        }
                    }
                }).start();
            }
        }
        catch (RuntimeException | BackingStoreException ex) {
            LOGGER.severe("creating spreadsheet failed", (Throwable)ex);
            Fx.error((String)FxFxBundle.getString((String)"COULD NOT CREATE EXCEL FILE"), (Throwable)ex);
        }
    }

    public void toXml(boolean onlySelected) {
        try {
            String prefName = StringHelper.trimRight((String)(LAST_XML_PREFIX + this.table.getConfiguration().getName()), (char)'/');
            PersistedPreferences prefs = PersistedPreferences.userRoot().node(prefName);
            String lastName = prefs.get("path", null);
            FileChooser fc = new FileChooser();
            if (lastName != null) {
                fc.setInitialFileName(lastName);
            }
            fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter(FxFxBundle.getString((String)"XML FILE"), new String[]{XML_EXTENSION})});
            File selectedFile = fc.showSaveDialog((Window)Fx.getStage(this.table));
            if (selectedFile != null) {
                if (!selectedFile.getName().toLowerCase().endsWith(XML_EXTENSION)) {
                    selectedFile = new File(selectedFile.getPath() + XML_EXTENSION);
                }
                TableUtilities.getInstance().toXml(this.table, selectedFile, onlySelected);
                if (!PersistedPreferencesFactory.getInstance().isReadOnly()) {
                    prefs.put("path", selectedFile.getAbsolutePath());
                    prefs.flush();
                }
            }
            if (selectedFile != null) {
                File xmlFile = selectedFile;
                new Thread(() -> {
                    try {
                        LOGGER.info("launching EDIT action for {0}", new Object[]{xmlFile});
                        Desktop.getDesktop().edit(xmlFile);
                    }
                    catch (IOException | UnsupportedOperationException ex) {
                        LOGGER.info("{0} -> trying OPEN action for {1}", new Object[]{ex.getMessage(), xmlFile});
                        try {
                            Desktop.getDesktop().open(xmlFile);
                            LOGGER.info("success!", new Object[0]);
                        }
                        catch (IOException ex2) {
                            LOGGER.severe("cannot open XML file", (Throwable)ex2);
                        }
                    }
                }).start();
            }
        }
        catch (RuntimeException | BackingStoreException ex) {
            LOGGER.severe("creating XML file failed", (Throwable)ex);
            Fx.error((String)FxFxBundle.getString((String)"COULD NOT CREATE XML FILE"), (Throwable)ex);
        }
    }

    public void savePreferences(boolean system) {
        try {
            this.table.savePreferences(this.preferencesSuffix, system);
        }
        catch (RuntimeException ex) {
            LOGGER.severe("saving table preferences failed", (Throwable)ex);
            Fx.error((String)FxFxBundle.getString((String)"PREFERENCES COULD NOT BE SAVED"), (Throwable)ex);
        }
    }

    public void savePreferences() {
        this.savePreferences(PersistedPreferencesFactory.getInstance().isSystemOnly());
    }

    public void loadPreferences(boolean system) {
        try {
            this.table.loadPreferences(this.preferencesSuffix, system, this.noViewSize);
        }
        catch (RuntimeException ex) {
            LOGGER.severe("loading table preferences failed", (Throwable)ex);
            Fx.error((String)FxFxBundle.getString((String)"PREFERENCES COULD NOT BE LOADED"), (Throwable)ex);
        }
    }

    public void loadPreferences() {
        this.loadPreferences(PersistedPreferencesFactory.getInstance().isSystemOnly());
    }
}

