/*
 * Tentackle - https://tentackle.org.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package org.tentackle.fx.container;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;

import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxController;
import org.tentackle.fx.ModelToViewListener;
import org.tentackle.fx.ViewToModelListener;
import org.tentackle.fx.container.delegate.FxBorderPaneDelegate;

/**
 * Extended BorderPane.
 *
 * @author harald
 */
public class FxBorderPane extends BorderPane implements FxContainer {

  /**
   * Creates a BorderPane layout.
   */
  public FxBorderPane() {
    super();
  }

  /**
   * Creates an BorderPane layout with the given Node as the center of the BorderPane.
   * <p>
   * @param center The node to set as the center of the BorderPane.
   */
  public FxBorderPane(Node center) {
    super(center);
  }

  /**
   * Creates an BorderPane layout with the given Nodes to use for each of the main layout areas of the Border Pane. The
   * top, right, bottom, and left nodes are listed in clockwise order.
   * <p>
   * @param center The node to set as the center of the BorderPane.
   * @param top    The node to set as the top of the BorderPane.
   * @param right  The node to set as the right of the BorderPane.
   * @param bottom The node to set as the bottom of the BorderPane.
   * @param left   The node to set as the left of the BorderPane.
   */
  public FxBorderPane(Node center, Node top, Node right, Node bottom, Node left) {
    super(center, top, right, bottom, left);
  }


  // @wurblet delegate Include $currentDir/fxcontainer.include

  //<editor-fold defaultstate="collapsed" desc="code 'delegate' generated by wurblet Include">//GEN-BEGIN:delegate

  private /**/FxBorderPaneDelegate/**/ delegate;          // @wurblet < Inject ${classname}Delegate

  /**
   * Creates the delegate.
   *
   * @return the delegate
   */
  protected /**/FxBorderPaneDelegate/**/ createDelegate() {  // @wurblet < Inject ${classname}Delegate
    return new /**/FxBorderPaneDelegate/**/(this);  // @wurblet < Inject ${classname}Delegate
  }

  @Override
  public /**/FxBorderPaneDelegate/**/ getDelegate() {  // @wurblet < Inject ${classname}Delegate
    if (delegate == null) {
      delegate = createDelegate();
    }
    return delegate;
  }

  @Override
  public FxContainer getParentContainer() {
    return getDelegate().getParentContainer();
  }

  @Override
  public ObservableList<?> getComponents() {
    return getDelegate().getComponents();
  }

  @Override
  public void setChangeable(boolean changeable) {
    getDelegate().setChangeable(changeable);
  }

  @Override
  public boolean isChangeable() {
    return getDelegate().isChangeable();
  }

  @Override
  public void setContainerChangeable(boolean containerChangeable) {
    getDelegate().setContainerChangeable(containerChangeable);
  }

  @Override
  public void setContainerChangableIgnored(boolean containerChangeableIgnored) {
    getDelegate().setContainerChangableIgnored(containerChangeableIgnored);
  }

  @Override
  public boolean isContainerChangeableIgnored() {
    return getDelegate().isContainerChangeableIgnored();
  }

  @Override
  public ReadOnlyBooleanProperty changeableProperty() {
    return getDelegate().changeableProperty();
  }

  @Override
  public void updateViewNonFocused() {
    getDelegate().updateViewNonFocused();
  }

  @Override
  public void updateView() {
    getDelegate().updateView();
  }

  @Override
  public void updateModel() {
    getDelegate().updateModel();
  }

  @Override
  public void saveView() {
    getDelegate().saveView();
  }

  @Override
  public void invalidateSavedView() {
    getDelegate().invalidateSavedView();
  }

  @Override
  public void triggerViewModified() {
    getDelegate().triggerViewModified();
  }

  @Override
  public void setViewModified(boolean viewModified) {
    getDelegate().setViewModified(viewModified);
  }

  @Override
  public boolean isViewModified() {
    return getDelegate().isViewModified();
  }

  @Override
  public BooleanProperty viewModifiedProperty() {
    return getDelegate().viewModifiedProperty();
  }

  @Override
  public void setBindable(boolean bindable) {
    getDelegate().setBindable(bindable);
  }

  @Override
  public boolean isBindable() {
    return getDelegate().isBindable();
  }

  @Override
  public void setHelpUrl(String helpUrl) {
    getDelegate().setHelpUrl(helpUrl);
  }

  @Override
  public String getHelpUrl() {
    return getDelegate().getHelpUrl();
  }

  @Override
  public void showHelp() {
    getDelegate().showHelp();
  }

  @Override
  public String toGenericString() {
    return getDelegate().toGenericString();
  }

  @Override
  public void clearErrors() {
    getDelegate().clearErrors();
  }

  @Override
  public FxController getController() {
    return getDelegate().getController();
  }

  @Override
  public void setController(FxController controller) {
    getDelegate().setController(controller);
  }

  @Override
  public <C extends FxController> C getController(Class<C> clazz) {
    return getDelegate().getController(clazz);
  }

  @Override
  public void addModelToViewListener(ModelToViewListener listener) {
    getDelegate().addModelToViewListener(listener);
  }

  @Override
  public void removeModelToViewListener(ModelToViewListener listener) {
    getDelegate().removeModelToViewListener(listener);
  }

  @Override
  public void addViewToModelListener(ViewToModelListener listener) {
    getDelegate().addViewToModelListener(listener);
  }

  @Override
  public void removeViewToModelListener(ViewToModelListener listener) {
    getDelegate().removeViewToModelListener(listener);
  }

  //</editor-fold>//GEN-END:delegate

}
