/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javafx.concurrent.Service;
import javafx.concurrent.Task;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.BuilderFactory;
import org.tentackle.common.BundleFactory;
import org.tentackle.common.LocaleProvider;
import org.tentackle.common.ServiceFactory;
import org.tentackle.fx.Configurator;
import org.tentackle.fx.FxBuilderFactory;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxControllerService;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.ImageProvider;
import org.tentackle.fx.ImageProviderService;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.ValueTranslatorKey;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.table.DefaultTableConfiguration;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.log.Logger;
import org.tentackle.reflect.DefaultClassMapper;
import org.tentackle.reflect.ReflectionHelper;

@org.tentackle.common.Service(value=FxFactory.class)
public class DefaultFxFactory
implements FxFactory {
    private static final Logger LOGGER = Logger.get(DefaultFxFactory.class);
    private final BuilderFactory builderFactory = this.createBuilderFactory();
    private final Map<String, Configurator<?>> configurators;
    private final Map<Class<?>, DefaultClassMapper> viewTranslatorMap;
    private final Map<Class<?>, Optional<Configurator<?>>> fxToConfiguratorMap;
    private final Collection<Class<FxController>> controllerClasses;
    private final Map<Class<? extends FxController>, FxController> controllers;
    private final Map<String, ImageProvider> imageProviders;

    public DefaultFxFactory() {
        try {
            this.controllerClasses = ServiceFactory.getServiceFinder().findServiceProviders(FxController.class);
        }
        catch (ClassNotFoundException ex) {
            throw new FxRuntimeException("loading FX controller classes failed", ex);
        }
        this.controllers = new HashMap<Class<? extends FxController>, FxController>();
        this.configurators = new HashMap();
        Map serviceMap = ServiceFactory.getServiceFinder().createNameMap(Configurator.class.getName());
        for (Map.Entry entry : serviceMap.entrySet()) {
            try {
                Class<?> configuratorClass = Class.forName((String)entry.getValue());
                this.configurators.put((String)entry.getKey(), (Configurator)configuratorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                throw new FxRuntimeException(ex);
            }
        }
        this.fxToConfiguratorMap = new HashMap();
        this.imageProviders = new HashMap<String, ImageProvider>();
        try {
            for (Object clazz : ServiceFactory.getServiceFinder().findServiceProviders(ImageProvider.class)) {
                ImageProviderService svc = ((Class)clazz).getAnnotation(ImageProviderService.class);
                if (svc != null) {
                    this.imageProviders.putIfAbsent(svc.value(), (ImageProvider)((Class)clazz).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    continue;
                }
                LOGGER.severe("{0} not annotated with @ImageProviderService", new Object[]{clazz});
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new FxRuntimeException("loading image providers failed", ex);
        }
        HashMap translatorMap = new HashMap();
        try {
            for (Class clazz : ServiceFactory.getServiceFinder().findServiceProviders(ValueTranslator.class)) {
                ValueTranslatorService svc = clazz.getAnnotation(ValueTranslatorService.class);
                if (svc != null) {
                    ValueTranslatorKey key = new ValueTranslatorKey(svc.modelClass(), svc.viewClass());
                    translatorMap.putIfAbsent(key, clazz);
                    continue;
                }
                LOGGER.severe("{0} not annotated with @ValueTranslatorService", new Object[]{clazz});
            }
        }
        catch (ClassNotFoundException ex) {
            throw new FxRuntimeException("loading value translators failed", ex);
        }
        this.viewTranslatorMap = new HashMap();
        for (Map.Entry entry : translatorMap.entrySet()) {
            Class viewClass = ((ValueTranslatorKey)entry.getKey()).getViewClass();
            DefaultClassMapper translators = this.viewTranslatorMap.computeIfAbsent(viewClass, k -> new DefaultClassMapper(ReflectionHelper.getClassBaseName((Class)viewClass) + "-translator", ServiceFactory.getClassLoader((String)"META-INF/services/", (String)ValueTranslator.class.getName()), new HashMap(), null));
            translators.getNameMap().put(((ValueTranslatorKey)entry.getKey()).getModelClass().getName(), ((Class)entry.getValue()).getName());
        }
    }

    @Override
    public BuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    @Override
    public <T> Configurator<T> getConfigurator(Class<T> clazz) {
        Configurator<?> configurator = null;
        Optional<Configurator<?>> optional = this.fxToConfiguratorMap.get(clazz);
        if (optional != null) {
            configurator = optional.orElse(null);
        } else {
            for (Class<T> cls = clazz; cls != Object.class && (configurator = this.configurators.get(cls.getName())) == null; cls = cls.getSuperclass()) {
            }
            this.fxToConfiguratorMap.put(clazz, Optional.ofNullable(configurator));
        }
        return configurator;
    }

    @Override
    public <M, V> ValueTranslator<V, M> createValueTranslator(Class<M> modelClass, Class<V> viewClass, FxComponent component) {
        DefaultClassMapper mapper;
        if (modelClass.isPrimitive()) {
            modelClass = ReflectionHelper.primitiveToWrapperClass(modelClass);
        }
        if ((mapper = this.viewTranslatorMap.get(viewClass)) == null) {
            throw new FxRuntimeException("no value translators for view " + viewClass);
        }
        try {
            Class clazz = mapper.mapLenient(modelClass);
            for (Constructor<?> cons : clazz.getConstructors()) {
                if (cons.getParameterCount() == 1 && FxComponent.class.isAssignableFrom(cons.getParameters()[0].getType())) {
                    return (ValueTranslator)cons.newInstance(component);
                }
                if (cons.getParameterCount() != 2 || !FxComponent.class.isAssignableFrom(cons.getParameters()[0].getType()) || cons.getParameters()[1].getType() != Class.class) continue;
                return (ValueTranslator)cons.newInstance(component, modelClass);
            }
            throw new ClassNotFoundException("no matching constructor found for " + clazz);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            throw new FxRuntimeException("could not create value translator for view " + viewClass + " to model " + modelClass, ex);
        }
    }

    @Override
    public Stage createStage(StageStyle stageStyle, Modality modality) {
        Stage stage = new Stage(stageStyle);
        stage.initModality(modality);
        this.getConfigurator(Window.class).configure((Window)stage);
        return stage;
    }

    @Override
    public synchronized <T extends FxController> T createController(Class<T> controllerClass, URL fxmlUrl, ResourceBundle resources, URL cssUrl) {
        boolean singleton;
        FxController controller = this.controllers.get(controllerClass);
        if (controller != null) {
            if (controller.getView().isVisible()) {
                throw new FxRuntimeException(controllerClass + " is a singleton and already visible");
            }
            return (T)controller;
        }
        FxControllerService service = controllerClass.getAnnotation(FxControllerService.class);
        if (service == null) {
            throw new FxRuntimeException("missing annotation @FxControllerService for controller " + controllerClass.getName());
        }
        boolean bl = singleton = service.caching() != FxControllerService.CACHING.NO;
        if (fxmlUrl == null) {
            Object urlStr = service.url();
            if (!((String)urlStr).isEmpty()) {
                fxmlUrl = controllerClass.getResource((String)urlStr);
                if (fxmlUrl == null) {
                    throw new FxRuntimeException("no such URL '" + (String)urlStr + "' -> check @FxControllerService of " + controllerClass.getName());
                }
            } else {
                urlStr = ReflectionHelper.getClassBaseName(controllerClass) + ".fxml";
                fxmlUrl = controllerClass.getResource((String)urlStr);
                if (fxmlUrl == null) {
                    throw new FxRuntimeException("no such default URL '" + (String)urlStr + "'");
                }
            }
        }
        if (resources == null) {
            String resourcesStr = service.resources();
            if (resourcesStr.isEmpty()) {
                resourcesStr = controllerClass.getName();
            }
            if (!"NONE".equals(resourcesStr)) {
                resources = BundleFactory.getBundle((String)resourcesStr, (Locale)LocaleProvider.getInstance().getLocale());
            }
        }
        FXMLLoader loader = new FXMLLoader(fxmlUrl, resources, this.getBuilderFactory());
        try {
            Parent view = (Parent)loader.load();
            controller = (FxController)loader.getController();
            controller.setView(view);
            if (view instanceof FxContainer) {
                ((FxContainer)view).setController(controller);
            }
            if (singleton) {
                this.controllers.put(controllerClass, controller);
                LOGGER.info("controller {0} added to singletons", new Supplier[]{() -> ReflectionHelper.getClassBaseName((Class)controllerClass)});
            }
            if (cssUrl == null) {
                Object cssName = service.css();
                if (((String)cssName).isEmpty()) {
                    cssName = ReflectionHelper.getClassBaseName(controllerClass) + ".css";
                }
                cssUrl = controllerClass.getResource((String)cssName);
            }
            if (cssUrl != null) {
                view.getStylesheets().add((Object)cssUrl.toExternalForm());
            }
            switch (service.binding()) {
                case YES: {
                    controller.getBinder().bind();
                    break;
                }
                case COMPONENT_INHERITED: {
                    controller.getBinder().bindWithInheritedComponents();
                    break;
                }
                case BINDABLE_INHERITED: {
                    controller.getBinder().bindWithInheritedBindables();
                    break;
                }
                case ALL_INHERITED: {
                    controller.getBinder().bindAllInherited();
                    break;
                }
            }
            controller.configure();
            return (T)controller;
        }
        catch (IOException iox) {
            throw new FxRuntimeException("loading controller " + controllerClass + " failed", iox);
        }
        catch (Throwable t) {
            LOGGER.severe("loading controller failed", t);
            throw t;
        }
    }

    @Override
    public Collection<Class<FxController>> getControllerClasses() {
        return this.controllerClasses;
    }

    @Override
    public void preloadControllers() {
        final ArrayList<Class<FxController>> preloadClasses = new ArrayList<Class<FxController>>();
        for (Class<FxController> clazz : this.getControllerClasses()) {
            FxControllerService service = clazz.getAnnotation(FxControllerService.class);
            if (service.caching() != FxControllerService.CACHING.PRELOAD) continue;
            preloadClasses.add(clazz);
        }
        Service<Void> preloadSvc = new Service<Void>(){

            protected Task<Void> createTask() {
                return new Task<Void>(){

                    protected Void call() throws Exception {
                        for (Class clazz : preloadClasses) {
                            DefaultFxFactory.this.createController(clazz, null, null, null);
                        }
                        return null;
                    }
                };
            }
        };
        preloadSvc.start();
    }

    @Override
    public Image getImage(String realm, String name) {
        ImageProvider provider;
        if (realm == null) {
            realm = "";
        }
        if ((provider = this.imageProviders.get(realm)) == null) {
            throw new IllegalArgumentException("no image provider for realm '" + realm + "'");
        }
        return provider.getImage(name);
    }

    @Override
    public <S> TableConfiguration<S> createTableConfiguration(S template, String name) {
        return new DefaultTableConfiguration<S>(template, name);
    }

    @Override
    public <S> TableConfiguration<S> createTableConfiguration(Class<S> objectClass, String name) {
        return new DefaultTableConfiguration<S>(objectClass, name);
    }

    protected BuilderFactory createBuilderFactory() {
        return new FxBuilderFactory();
    }
}

