/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxUtilities;

public class Fx {
    public static <T> T load(URL location) throws IOException {
        FXMLLoader loader = new FXMLLoader(location, null, FxFactory.getInstance().getBuilderFactory());
        return (T)loader.load();
    }

    public static <T> T load(URL location, ResourceBundle resources) throws IOException {
        FXMLLoader loader = new FXMLLoader(location, resources, FxFactory.getInstance().getBuilderFactory());
        return (T)loader.load();
    }

    public static <T extends FxController> T load(Class<T> controllerClass) {
        return FxFactory.getInstance().createController(controllerClass, null, null, null);
    }

    public static Stage createStage(StageStyle stageStyle, Modality modality) {
        return FxFactory.getInstance().createStage(stageStyle, modality);
    }

    public static Stage createStage(Modality modality) {
        return Fx.createStage(StageStyle.DECORATED, modality);
    }

    public static <T, R extends T> R createNode(Class<T> clazz) {
        return (R)FxFactory.getInstance().getBuilderFactory().getBuilder(clazz).build();
    }

    public static void info(String message, String title) {
        FxUtilities.getInstance().showInfoDialog(message, title);
    }

    public static void info(String message) {
        FxUtilities.getInstance().showInfoDialog(message, null);
    }

    public static void warning(String message, String title) {
        FxUtilities.getInstance().showWarningDialog(message, title);
    }

    public static void warning(String message) {
        FxUtilities.getInstance().showWarningDialog(message, null);
    }

    public static void question(String message, boolean defaultYes, String title, Consumer<Boolean> answer) {
        FxUtilities.getInstance().showQuestionDialog(message, defaultYes, title, answer);
    }

    public static void question(String message, boolean defaultYes, Consumer<Boolean> answer) {
        FxUtilities.getInstance().showQuestionDialog(message, defaultYes, null, answer);
    }

    public static void yes(String message, boolean defaultYes, Runnable yes) {
        FxUtilities.getInstance().showQuestionDialog(message, defaultYes, null, answer -> {
            if (answer.booleanValue()) {
                yes.run();
            }
        });
    }

    public static void no(String message, boolean defaultYes, Runnable no) {
        FxUtilities.getInstance().showQuestionDialog(message, defaultYes, null, answer -> {
            if (!answer.booleanValue()) {
                no.run();
            }
        });
    }

    public static void error(String message, Throwable t, String title) {
        FxUtilities.getInstance().showErrorDialog(message, t, title);
    }

    public static void error(String message, Throwable t) {
        FxUtilities.getInstance().showErrorDialog(message, t, null);
    }

    public static void error(String message) {
        FxUtilities.getInstance().showErrorDialog(message, null, null);
    }

    public static ImageView createImageView(String realm, String name) {
        return new ImageView(FxFactory.getInstance().getImage(realm, name));
    }

    public static ImageView createImageView(String name) {
        return Fx.createImageView("", name);
    }

    public static Stage getStage(Node node) {
        return FxUtilities.getInstance().getStage(node);
    }

    public static boolean isModal(Stage stage) {
        return FxUtilities.getInstance().isModal(stage);
    }

    private Fx() {
    }
}

