/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxControl;
import org.tentackle.fx.FxControlDelegate;
import org.tentackle.fx.FxController;

public abstract class FxContainerDelegate
extends FxControlDelegate
implements FxContainer {
    private FxController controller;

    public abstract FxContainer getContainer();

    @Override
    public FxContainer getParentContainer() {
        for (Parent parent = this.getNode().getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof FxContainer)) continue;
            return (FxContainer)parent;
        }
        return null;
    }

    @Override
    public FxController getController() {
        return this.controller;
    }

    @Override
    public void setController(FxController controller) {
        this.controller = controller;
    }

    @Override
    public <C extends FxController> C getController(Class<C> clazz) {
        for (FxContainer cont = this.getContainer(); cont != null; cont = cont.getParentContainer()) {
            FxController cntrl = cont.getController();
            if (cntrl == null || !clazz.isAssignableFrom(cntrl.getClass())) continue;
            return (C)cntrl;
        }
        return null;
    }

    @Override
    public String toGenericString() {
        StringBuilder buf = new StringBuilder();
        buf.append("container ").append(this.getContainer().getClass().getName());
        String id = ((Node)this.getContainer()).getId();
        if (id != null) {
            buf.append('[').append(id).append(']');
        }
        return buf.toString();
    }

    public String toString() {
        return "delegate for " + this.toGenericString();
    }

    public Node getNode() {
        return (Node)this.getContainer();
    }

    @Override
    public void updateViewNonFocused() {
        for (Object obj : this.getContainer().getComponents()) {
            if (obj instanceof FxContainer) {
                ((FxContainer)obj).updateViewNonFocused();
                continue;
            }
            if (!(obj instanceof FxControl) || obj instanceof Node && ((Node)obj).isFocused()) continue;
            ((FxControl)obj).updateView();
        }
    }

    @Override
    public void updateView() {
        for (Object obj : this.getContainer().getComponents()) {
            if (!(obj instanceof FxControl)) continue;
            ((FxControl)obj).updateView();
        }
    }

    @Override
    public void updateModel() {
        for (Object obj : this.getContainer().getComponents()) {
            if (!(obj instanceof FxControl)) continue;
            ((FxControl)obj).updateModel();
        }
    }

    @Override
    public void triggerViewModified() {
        boolean modified = false;
        for (Object component : this.getComponents()) {
            if (!(component instanceof FxControl) || !((FxControl)component).isViewModified()) continue;
            modified = true;
            break;
        }
        this.setViewModified(modified);
        if (this.getParentContainer() != null) {
            this.getParentContainer().triggerViewModified();
        }
    }

    @Override
    public void saveView() {
        for (Object component : this.getComponents()) {
            if (!(component instanceof FxControl)) continue;
            ((FxControl)component).saveView();
        }
        this.setViewModified(false);
    }

    @Override
    public void invalidateSavedView() {
        for (Object component : this.getComponents()) {
            if (!(component instanceof FxControl)) continue;
            ((FxControl)component).invalidateSavedView();
        }
    }

    @Override
    public void setBindable(boolean bindable) {
        super.setBindable(bindable);
        for (Object component : this.getComponents()) {
            if (!(component instanceof FxControl)) continue;
            ((FxControl)component).setBindable(bindable);
        }
    }

    @Override
    public void setChangeable(boolean changeable) {
        if (changeable != this.isChangeable()) {
            super.setChangeable(changeable);
            this.setContainerChangeable((List<?>)this.getComponents(), changeable);
        }
    }

    @Override
    public void setContainerChangeable(boolean containerChangeable) {
        if (!this.isContainerChangeableIgnored()) {
            this.setContainerChangeable((List<?>)this.getComponents(), containerChangeable);
        }
    }

    protected void setContainerChangeable(List<?> components, boolean changeable) {
        for (Object component : components) {
            if (!(component instanceof FxControl)) continue;
            ((FxControl)component).setContainerChangeable(changeable);
        }
    }

    @Override
    public void clearErrors() {
        for (Object component : this.getComponents()) {
            if (component instanceof FxComponent) {
                ((FxComponent)component).setError(null);
                continue;
            }
            if (!(component instanceof FxContainer)) continue;
            ((FxContainer)component).clearErrors();
        }
    }
}

