/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.config;

import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import org.tentackle.fx.FxUtilities;

public class PrefixSelectionFeature<T extends Control> {
    public static final String ENABLED = "prefixSelectionEnabled";
    protected final T control;
    protected final BooleanSupplier condition;
    protected final Supplier<Collection> itemProvider;
    protected final StringConverter itemConverter;
    protected final Consumer<Integer> selector;
    protected final StringBuilder prefixBuf;
    private long lastPressMillis;
    private int index;

    public PrefixSelectionFeature(T control, BooleanSupplier condition, Supplier<Collection> itemProvider, StringConverter itemConverter, Consumer<Integer> selector) {
        this.control = control;
        this.condition = condition;
        this.itemProvider = itemProvider;
        this.itemConverter = itemConverter;
        this.selector = selector;
        this.prefixBuf = new StringBuilder();
    }

    public void configure() {
        this.control.addEventHandler(KeyEvent.KEY_TYPED, this.createHandler());
    }

    protected EventHandler<KeyEvent> createHandler() {
        return event -> {
            String chr;
            if (this.isEnabled() && (chr = event.getCharacter()) != null) {
                long now = System.currentTimeMillis();
                if (now > this.lastPressMillis + FxUtilities.getInstance().getPrefixSelectionTimeout()) {
                    this.prefixBuf.setLength(0);
                    this.index = 0;
                }
                this.lastPressMillis = now;
                this.prefixBuf.append(chr);
                this.select();
            }
        };
    }

    protected boolean isEnabled() {
        return this.condition.getAsBoolean() && this.control.getProperties().containsKey((Object)ENABLED);
    }

    protected void select() {
        String prefix = this.getPrefix();
        int i = 0;
        for (Object item : this.itemProvider.get()) {
            if (i >= this.index && this.isItemMatching(prefix, item)) {
                this.index = i;
                this.selector.accept(this.index);
                break;
            }
            ++i;
        }
    }

    protected String getPrefix() {
        return this.prefixBuf.toString().toUpperCase();
    }

    protected boolean isItemMatching(String prefix, Object item) {
        String itemText = this.itemConverter == null ? item.toString() : this.itemConverter.toString(item);
        return itemText != null && itemText.toUpperCase().startsWith(prefix);
    }
}

