/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.config;

import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tentackle.fx.ConfiguratorService;
import org.tentackle.fx.component.config.TextInputControlConfigurator;

@ConfiguratorService(value=TextArea.class)
public class TextAreaConfigurator<T extends TextArea>
extends TextInputControlConfigurator<T> {
    @Override
    protected void remapKeys(T control) {
        control.addEventFilter(KeyEvent.ANY, event -> {
            if (!(event.getCode() != KeyCode.TAB && event.getCode() != KeyCode.ENTER || event.isAltDown() || event.isMetaDown())) {
                if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                    if (event.isControlDown()) {
                        control.insertText(control.getCaretPosition(), event.getCode() == KeyCode.TAB ? "\t" : "\n");
                    } else if (event.isShiftDown()) {
                        this.focusPrevious(control);
                    } else {
                        this.focusNext(control);
                    }
                }
                event.consume();
            }
        });
    }
}

