/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import javafx.scene.Parent;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxTextComponentDelegate;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.component.FxHTMLEditor;

public class FxHTMLEditorDelegate
extends FxTextComponentDelegate {
    private final FxHTMLEditor component;
    private int columns;

    public FxHTMLEditorDelegate(FxHTMLEditor component) {
        this.component = component;
    }

    @Override
    public FxHTMLEditor getComponent() {
        return this.component;
    }

    @Override
    public FxContainer getParentContainer() {
        Parent parent = this.component.getParent();
        return parent instanceof FxContainer ? (FxContainer)parent : null;
    }

    @Override
    public void setColumns(int columns) {
        this.columns = columns;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public String getViewObject() {
        String text = this.component.getHtmlText();
        return StringHelper.isAllWhitespace((String)text) ? null : text;
    }

    @Override
    public void setViewObject(Object viewObject) {
        this.component.setHtmlText((String)viewObject);
    }

    @Override
    public void setViewValue(Object value) {
        ValueTranslator<?, ?> translator = this.getValueTranslator();
        this.setViewObject(translator.toView(value));
    }

    @Override
    public <V> V getViewValue() {
        ValueTranslator<?, ?> translator = this.getValueTranslator();
        return (V)translator.toModel(this.getViewObject());
    }

    @Override
    public void mapErrorOffsetToCaretPosition() {
    }
}

