/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import javafx.collections.ObservableList;
import javafx.scene.Parent;
import org.tentackle.fx.FxComponentDelegate;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.misc.TrackedList;

public class FxTableViewDelegate
extends FxComponentDelegate {
    private final FxTableView<?> component;
    private TrackedList<?> modelList;

    public FxTableViewDelegate(FxTableView<?> component) {
        this.component = component;
    }

    @Override
    public FxTableView<?> getComponent() {
        return this.component;
    }

    @Override
    public FxContainer getParentContainer() {
        Parent parent = this.component.getParent();
        return parent instanceof FxContainer ? (FxContainer)parent : null;
    }

    @Override
    public void setType(Class<?> type) {
        super.setType(type);
        if (this.getValueTranslator() == null) {
            this.setValueTranslator(FxFactory.getInstance().createValueTranslator(type, ObservableList.class, this.getComponent()));
        }
    }

    public ObservableList getViewObject() {
        return this.component.getItems();
    }

    @Override
    public void setViewObject(Object viewObject) {
        if (viewObject != this.component.getItems()) {
            this.component.setItems((ObservableList)viewObject);
            this.component.getSelectionModel().clearSelection();
            this.component.refresh();
        }
    }

    @Override
    public void setViewValue(Object value) {
        this.modelList = value instanceof TrackedList ? (TrackedList)value : null;
        ValueTranslator<?, ?> translator = this.getValueTranslator();
        this.setViewObject(translator.toView(value));
    }

    @Override
    public <V> V getViewValue() {
        ValueTranslator<?, ?> translator = this.getValueTranslator();
        return (V)translator.toModel(this.getViewObject());
    }

    @Override
    public boolean isViewModified() {
        if (this.modelList != null) {
            return this.modelList.isModified();
        }
        return super.isViewModified();
    }

    @Override
    public void triggerViewModified() {
        if (this.getParentContainer() != null) {
            this.getParentContainer().triggerViewModified();
        }
    }

    @Override
    public void updateModel() {
    }

    @Override
    protected void updateChangeable(boolean changeable) {
    }

    @Override
    public void setContainerChangeable(boolean containerChangeable) {
    }
}

