/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.prefs.BackingStoreException;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import org.tentackle.common.LocaleProvider;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.bind.FxBindingFactory;
import org.tentackle.fx.bind.FxTableBinder;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.table.DefaultTableColumnConfiguration;
import org.tentackle.fx.table.TableCellType;
import org.tentackle.fx.table.TableCellTypeFactory;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.prefs.PersistedPreferences;
import org.tentackle.reflect.EffectiveClassProvider;
import org.tentackle.reflect.ReflectionHelper;

public class DefaultTableConfiguration<S>
implements TableConfiguration<S> {
    private static final String PREF_WIDTH = "width";
    private static final String PREF_TABLE_HEIGHT = "height";
    private static final String PREF_COLUMN_INDEX = "index";
    private static final String PREF_COLUMN_VISIBILITY = "visible";
    private static final String PREF_COLUMN_SORT_TYPE = "sort_type";
    private static final String PREF_COLUMN_SORT_INDEX = "sort_ndx";
    private final S template;
    private final String name;
    private final Class<S> objectClass;
    private final Map<String, TableColumnConfiguration<S, ?>> nameColumnConfigMap;
    private final Map<TableColumn<S, ?>, TableColumnConfiguration<S, ?>> columnColumnConfigMap;
    private FxTableBinder<S> binder;
    private boolean sortingIncluded;
    private TableConfiguration.EDITMODE editMode = TableConfiguration.EDITMODE.NO;

    public DefaultTableConfiguration(S template, String name) {
        this.template = template;
        this.objectClass = EffectiveClassProvider.getEffectiveClass(template);
        this.name = name == null ? ReflectionHelper.getClassBaseName(this.objectClass) : name;
        this.nameColumnConfigMap = new LinkedHashMap();
        this.columnColumnConfigMap = new LinkedHashMap();
    }

    public DefaultTableConfiguration(Class<S> objectClass, String name) {
        this.template = null;
        this.objectClass = objectClass;
        this.name = name == null ? ReflectionHelper.getClassBaseName(objectClass) : name;
        this.nameColumnConfigMap = new LinkedHashMap();
        this.columnColumnConfigMap = new LinkedHashMap();
    }

    public S getTemplate() {
        return this.template;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public TableColumnConfiguration<S, ?> addColumn(String name, String displayedName) {
        DefaultTableColumnConfiguration columnConfiguration = new DefaultTableColumnConfiguration(this, name, displayedName);
        this.addColumnConfiguration(columnConfiguration);
        return columnConfiguration;
    }

    @Override
    public void addColumnConfiguration(TableColumnConfiguration<S, ?> columnConfiguration) {
        this.nameColumnConfigMap.put(columnConfiguration.getName(), columnConfiguration);
        this.columnColumnConfigMap.put(columnConfiguration.getTableColumn(), columnConfiguration);
    }

    @Override
    public Collection<TableColumnConfiguration<S, ?>> getColumnConfigurations() {
        return this.nameColumnConfigMap.values();
    }

    @Override
    public TableColumnConfiguration<S, ?> getColumnConfiguration(String name) {
        return name == null ? null : this.nameColumnConfigMap.get(name);
    }

    @Override
    public TableColumnConfiguration<S, ?> getColumnConfiguration(TableColumn<S, ?> column) {
        return column == null ? null : this.columnColumnConfigMap.get(column);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSortingIncluded() {
        return this.sortingIncluded;
    }

    @Override
    public void setSortingIncluded(boolean sortingIncluded) {
        this.sortingIncluded = sortingIncluded;
    }

    @Override
    public void savePreferences(FxTableView<S> table, String suffix, boolean system) {
        StringBuilder prefName = new StringBuilder();
        prefName.append(this.name);
        if (suffix != null) {
            prefName.append('_').append(suffix);
        }
        prefName.append('_').append(LocaleProvider.getInstance().getEffectiveLocale());
        ObservableList sortOrder = table.getSortOrder();
        try {
            PersistedPreferences prefs = system ? PersistedPreferences.systemRoot().node(prefName.toString()) : PersistedPreferences.userRoot().node(prefName.toString());
            int viewIndex = 0;
            for (TableColumn column : table.getColumns()) {
                TableColumnConfiguration<S, ?> columnConfig = this.getColumnConfiguration(column);
                if (columnConfig != null) {
                    PersistedPreferences columnPrefs = prefs.node(columnConfig.getName());
                    columnPrefs.putInt(PREF_COLUMN_VISIBILITY, column.isVisible() ? 1 : 0);
                    columnPrefs.putDouble(PREF_WIDTH, column.getWidth());
                    columnPrefs.putInt(PREF_COLUMN_INDEX, viewIndex);
                    int sortIndex = sortOrder.indexOf((Object)column);
                    if (this.isSortingIncluded() && sortIndex >= 0) {
                        columnPrefs.putInt(PREF_COLUMN_SORT_TYPE, column.getSortType().ordinal());
                        columnPrefs.putInt(PREF_COLUMN_SORT_INDEX, sortIndex);
                    } else {
                        columnPrefs.remove(PREF_COLUMN_SORT_TYPE);
                        columnPrefs.remove(PREF_COLUMN_SORT_INDEX);
                    }
                }
                ++viewIndex;
            }
            double height = table.getHeight();
            if (table.getTotalsTableView() != null) {
                height += table.getTotalsTableView().getHeight();
            }
            prefs.putDouble(PREF_TABLE_HEIGHT, height);
            prefs.putDouble(PREF_WIDTH, table.getWidth());
            prefs.flush();
        }
        catch (RuntimeException | BackingStoreException ex) {
            throw new FxRuntimeException("saving table preferences failed for '" + prefName + "'", ex);
        }
    }

    @Override
    public void loadPreferences(FxTableView<S> table, String suffix, boolean system, boolean noViewSize) {
        StringBuilder prefName = new StringBuilder();
        prefName.append(this.name);
        if (suffix != null) {
            prefName.append('_').append(suffix);
        }
        prefName.append('_').append(LocaleProvider.getInstance().getEffectiveLocale());
        TreeMap sortOrder = new TreeMap();
        try {
            PersistedPreferences systemPref = PersistedPreferences.systemRoot().node(prefName.toString());
            PersistedPreferences userPref = system ? null : PersistedPreferences.userRoot().node(prefName.toString());
            HashMap<String, PersistedPreferences> columnMapByName = new HashMap<String, PersistedPreferences>();
            for (String columnName : systemPref.childrenNames()) {
                columnMapByName.put(columnName, systemPref.node(columnName));
            }
            if (userPref != null) {
                for (String columnName : userPref.childrenNames()) {
                    columnMapByName.put(columnName, userPref.node(columnName));
                }
            }
            TreeMap columnMapByIndex = new TreeMap();
            for (Map.Entry entry : columnMapByName.entrySet()) {
                int sorting;
                int index;
                TableColumn<S, ?> column;
                TableColumnConfiguration<S, ?> columnConfig = this.getColumnConfiguration((String)entry.getKey());
                if (columnConfig == null || (column = columnConfig.getTableColumn()) == null) continue;
                PersistedPreferences columnPref = (PersistedPreferences)entry.getValue();
                int visibility = columnPref.getInt(PREF_COLUMN_VISIBILITY, -1);
                column.setVisible(visibility != 0);
                double width = columnPref.getDouble(PREF_WIDTH, -1.0);
                if (width >= 0.0) {
                    table.resizeColumn(column, width - column.getWidth());
                }
                if ((index = columnPref.getInt(PREF_COLUMN_INDEX, -1)) < 0) continue;
                columnMapByIndex.put(index, column);
                if (!this.isSortingIncluded() || (sorting = columnPref.getInt(PREF_COLUMN_SORT_TYPE, -1)) < 0) continue;
                column.setSortType(TableColumn.SortType.values()[sorting]);
                int sortIndex = columnPref.getInt(PREF_COLUMN_SORT_INDEX, -1);
                if (sortIndex == -1) {
                    sortIndex = Integer.MAX_VALUE - sortOrder.size();
                }
                sortOrder.put(sortIndex, column);
            }
            table.getColumns().removeAll(columnMapByIndex.values());
            table.getColumns().addAll(columnMapByIndex.values());
            table.getSortOrder().addAll(sortOrder.values());
            if (!noViewSize) {
                double width = -1.0;
                String key = PREF_WIDTH;
                if (!system) {
                    width = userPref.getDouble(key, width);
                }
                if (width < 0.0) {
                    width = systemPref.getDouble(key, width);
                }
                if (width > 0.0) {
                    table.setPrefWidth(width);
                }
                double height = -1.0;
                key = PREF_TABLE_HEIGHT;
                if (!system) {
                    height = userPref.getDouble(key, height);
                }
                if (height < 0.0) {
                    height = systemPref.getDouble(key, height);
                }
                if (height > 0.0) {
                    table.setPrefHeight(height);
                }
            }
        }
        catch (RuntimeException | BackingStoreException ex) {
            throw new FxRuntimeException("loading table preferences failed for '" + prefName + "'", ex);
        }
    }

    @Override
    public TableConfiguration.EDITMODE getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(TableConfiguration.EDITMODE editMode) {
        this.editMode = editMode == null ? TableConfiguration.EDITMODE.NO : editMode;
    }

    @Override
    public void configure(FxTableView<S> table) {
        table.getColumns().clear();
        boolean tableEditable = false;
        for (TableColumnConfiguration<S, ?> config : this.nameColumnConfigMap.values()) {
            boolean columnEditable = config.isEditable();
            tableEditable |= columnEditable;
            TableColumn<S, ?> column = config.getTableColumn();
            column.setEditable(columnEditable);
            table.getColumns().add(column);
        }
        table.setEditable(tableEditable);
        table.getSelectionModel().cellSelectionEnabledProperty().set(tableEditable);
        table.setConfiguration(this);
    }

    @Override
    public Class<S> getObjectClass() {
        return this.objectClass;
    }

    @Override
    public TableConfiguration.BINDING getBindingType() {
        return TableConfiguration.BINDING.YES;
    }

    @Override
    public FxTableBinder<S> getBinder() {
        if (this.binder == null) {
            this.binder = FxBindingFactory.getInstance().createTableBinder(this);
        }
        return this.binder;
    }

    @Override
    public <T> TableCellType<T> getCellType(Class<T> type) {
        return TableCellTypeFactory.getInstance().getTableCellType(type);
    }
}

