/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table;

import java.util.Collection;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.table.FxTableColumn;

public class TotalsTableView<S>
extends FxTableView<S> {
    private FxTableView<S> boundTable;
    private final ListChangeListener<TableColumn<S, ?>> columnListener = c -> {
        while (c.next()) {
            if (!c.wasAdded()) continue;
            ObservableList totalsColumns = FXCollections.observableArrayList((Collection)this.getColumns());
            int j = c.getFrom();
            for (TableColumn col : c.getAddedSubList()) {
                int i = c.getRemoved().indexOf(col);
                if (i < 0) continue;
                totalsColumns.set(j, (Object)((TableColumn)this.getColumns().get(i)));
                ++j;
            }
            this.getColumns().setAll((Collection)totalsColumns);
        }
    };

    public TotalsTableView() {
        this.applyCSS();
        this.enableCopyToClipboard();
    }

    public void setBoundTable(FxTableView<S> boundTable) {
        this.unbind();
        this.boundTable = boundTable;
        this.bind();
    }

    public TableView<S> getBoundTable() {
        return this.boundTable;
    }

    protected void applyCSS() {
        this.getStylesheets().addAll((Object[])new String[]{TotalsTableView.class.getResource("totalstable.css").toExternalForm()});
        this.getStyleClass().add((Object)"totalstable");
    }

    protected void enableCopyToClipboard() {
        this.getSelectionModel().setCellSelectionEnabled(true);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setOnKeyPressed(e -> {
            if (e.isControlDown() && e.getCode() == KeyCode.C) {
                StringBuilder buf = new StringBuilder();
                for (TablePosition pos : this.getSelectionModel().getSelectedCells()) {
                    Object cell = ((TableColumn)this.getColumns().get(pos.getColumn())).getCellData(pos.getRow());
                    if (cell == null) continue;
                    if (buf.length() > 0) {
                        buf.append('\t');
                    }
                    buf.append(cell);
                }
                if (buf.length() > 0) {
                    ClipboardContent cbc = new ClipboardContent();
                    cbc.putString(buf.toString());
                    Clipboard.getSystemClipboard().setContent((Map)cbc);
                }
            }
        });
    }

    protected void bind() {
        if (this.boundTable != null) {
            for (TableColumn boundColumn : this.boundTable.getColumns()) {
                this.getColumns().add(this.createTotalsColumn(boundColumn));
            }
            this.boundTable.getColumns().addListener(this.columnListener);
            this.boundTable.setTotalsTableView(this);
        }
    }

    protected void unbind() {
        if (this.boundTable != null) {
            this.boundTable.setTotalsTableView(null);
            this.boundTable.getColumns().removeListener(this.columnListener);
        }
        this.getColumns().clear();
    }

    protected TableColumn<S, ?> createTotalsColumn(TableColumn<S, ?> boundColumn) {
        TableColumn totalsColumn = new TableColumn();
        if (this.isSummable(boundColumn)) {
            totalsColumn.setCellValueFactory(boundColumn.getCellValueFactory());
            totalsColumn.setCellFactory(boundColumn.getCellFactory());
        }
        totalsColumn.prefWidthProperty().bind((ObservableValue)boundColumn.widthProperty());
        totalsColumn.visibleProperty().bind((ObservableValue)boundColumn.visibleProperty());
        return totalsColumn;
    }

    protected boolean isSummable(TableColumn<S, ?> boundColumn) {
        return boundColumn instanceof FxTableColumn && ((FxTableColumn)boundColumn).getConfiguration().isSummable();
    }
}

