/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table.type;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javafx.geometry.Pos;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.TableCellTypeService;
import org.tentackle.fx.table.type.AbstractTableCellType;
import org.tentackle.misc.FormatHelper;

@TableCellTypeService(value=LocalTime.class)
public class LocalTimeTableCellType
extends AbstractTableCellType<LocalTime> {
    @Override
    public void updateItem(FxTableCell<?, LocalTime> tableCell, LocalTime item) {
        tableCell.setGraphic(null);
        DateTimeFormatter fmt = tableCell.getColumnConfiguration().getDateTimeFormatter();
        if (fmt == null) {
            fmt = FormatHelper.getLocalTimeFormatter();
        }
        String text = fmt.format(item);
        tableCell.setText(text);
        this.updateAlignment(tableCell, Pos.CENTER);
    }
}

