/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table.type;

import java.text.DecimalFormat;
import javafx.geometry.Pos;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.TableCellTypeService;
import org.tentackle.fx.table.type.AbstractTableCellType;

@TableCellTypeService(value=Number.class)
public class NumberTableCellType<T extends Number>
extends AbstractTableCellType<T> {
    @Override
    public void updateItem(FxTableCell<?, T> tableCell, T item) {
        tableCell.setGraphic(null);
        DecimalFormat fmt = this.getFormat(tableCell, item);
        String text = fmt != null ? fmt.format(item) : item.toString();
        tableCell.setText(text);
        this.updateAlignment(tableCell, Pos.CENTER_RIGHT);
    }

    protected DecimalFormat getFormat(FxTableCell<?, T> tableCell, T item) {
        return tableCell.getColumnConfiguration().getNumberFormat();
    }
}

