/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.util.List;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.translate.AbstractValueTranslator;

@ValueTranslatorService(modelClass=List.class, viewClass=ObservableList.class)
public class ObservableListTranslator<T, C extends List<T>>
extends AbstractValueTranslator<C, ObservableList<T>> {
    public ObservableListTranslator(FxComponent component) {
        super(component);
    }

    @Override
    public Function<C, ObservableList<T>> toViewFunction() {
        return m -> {
            ObservableList items;
            ObservableList observableList = items = m instanceof ObservableList ? (ObservableList)m : FXCollections.observableList((List)m);
            if (this.getComponent() instanceof TableView) {
                boolean sortable = false;
                for (TableColumn column : ((TableView)this.getComponent()).getColumns()) {
                    if (!column.isSortable()) continue;
                    sortable = true;
                    break;
                }
                if (sortable && !(items instanceof SortedList)) {
                    SortedList sortedResult = new SortedList(items);
                    sortedResult.comparatorProperty().bind((ObservableValue)((TableView)this.getComponent()).comparatorProperty());
                    items = sortedResult;
                }
            }
            return items;
        };
    }

    @Override
    public Function<ObservableList<T>, C> toModelFunction() {
        throw new FxRuntimeException("conversion to model is not applicable to lists");
    }
}

