/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import com.sun.javafx.fxml.BeanAdapter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javafx.scene.control.Label;
import javafx.util.Builder;
import org.tentackle.fx.Configurator;
import org.tentackle.fx.FxFactory;

public abstract class AbstractBuilder<T>
extends BeanAdapter
implements Builder<T> {
    private static final Label DUMMY_LABEL = new Label();
    private final Set<String> innerElements;

    public AbstractBuilder(T bean) {
        super(bean);
        this.innerElements = null;
    }

    public AbstractBuilder(T bean, String ... innerElements) {
        super(bean);
        this.innerElements = innerElements == null ? null : new HashSet<String>(Arrays.asList(innerElements));
    }

    public T getBean() {
        return (T)super.getBean();
    }

    public Object get(Object key) {
        return this.innerElements != null && this.innerElements.contains(key) ? DUMMY_LABEL : super.get(key);
    }

    public T build() {
        T bean = this.getBean();
        Class<?> clazz = bean.getClass();
        Configurator<?> configurator = FxFactory.getInstance().getConfigurator(clazz);
        if (configurator != null) {
            configurator.configure(bean);
        }
        return bean;
    }
}

