/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.bind.FxBindingFactory;
import org.tentackle.fx.bind.FxComponentBinder;
import org.tentackle.log.Logger;
import org.tentackle.misc.ImmutableArrayList;
import org.tentackle.validate.ScopeConfigurator;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.scope.ChangeableScope;
import org.tentackle.validate.scope.MandatoryScope;

public abstract class AbstractFxController
implements FxController,
ScopeConfigurator {
    private static final Logger LOGGER = Logger.get(AbstractFxController.class);
    private Parent view;
    private FxContainer container;
    private FxComponentBinder binder;
    private ImmutableArrayList<Field> fxmlFields;
    private ImmutableArrayList<Method> fxmlMethods;

    @Override
    public Parent getView() {
        return this.view;
    }

    @Override
    public void setView(Parent view) {
        this.view = view;
        this.container = view instanceof FxContainer ? (FxContainer)view : null;
    }

    @Override
    public Stage getStage() {
        Window window;
        Stage stage = null;
        Scene scene = this.getView().getScene();
        if (scene != null && scene.getRoot() == this.getView() && (window = scene.getWindow()) instanceof Stage) {
            stage = (Stage)window;
        }
        return stage;
    }

    @Override
    public FxContainer getContainer() {
        return this.container;
    }

    @Override
    public List<Field> getFXMLFields() {
        if (this.fxmlFields == null) {
            this.fxmlFields = new ImmutableArrayList();
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(FXML.class)) continue;
                this.fxmlFields.add((Object)field);
                LOGGER.fine("added {0} to @FXML-fields", new Object[]{field});
            }
            this.fxmlFields.setImmutable(true);
        }
        return this.fxmlFields;
    }

    @Override
    public List<Method> getFXMLMethods() {
        if (this.fxmlMethods == null) {
            this.fxmlMethods = new ImmutableArrayList();
            for (Method method : this.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(FXML.class)) continue;
                this.fxmlMethods.add((Object)method);
                LOGGER.fine("added {0} to @FXML-methods", new Object[]{method});
            }
            this.fxmlMethods.setImmutable(true);
        }
        return this.fxmlMethods;
    }

    @Override
    public void validateInjections() {
        for (Field field : this.getFXMLFields()) {
            try {
                Object comp;
                try {
                    comp = field.get(this);
                }
                catch (IllegalAccessException ex) {
                    field.setAccessible(true);
                    comp = field.get(this);
                }
                if (comp != null) continue;
                throw new FxRuntimeException(field + " annotated with @FXML was not injected");
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                throw new FxRuntimeException("cannot verify " + field, ex);
            }
        }
    }

    public Class<? extends ValidationScope>[] getDefaultScopes() {
        return new Class[]{MandatoryScope.class, ChangeableScope.class};
    }

    protected FxComponentBinder createBinder() {
        return FxBindingFactory.getInstance().createComponentBinder(this);
    }

    @Override
    public FxComponentBinder getBinder() {
        if (this.binder == null) {
            this.binder = this.createBinder();
        }
        return this.binder;
    }

    @Override
    public void configure() {
    }
}

