/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javafx.scene.image.Image;
import org.tentackle.fx.ImageProvider;
import org.tentackle.fx.ImageProviderService;
import org.tentackle.log.Logger;
import org.tentackle.reflect.ReflectionHelper;

@ImageProviderService
public class DefaultImageProvider
implements ImageProvider {
    private static final Logger LOGGER = Logger.get(DefaultImageProvider.class);
    private static final String[] EXTENSIONS = new String[]{".png", ".gif", ".jpg"};
    private final Map<String, Image> imageMap = new ConcurrentHashMap<String, Image>();
    private final String imagePath = "/" + ReflectionHelper.getPackageName(this.getClass()).replace('.', '/') + "/images/";

    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public Image getImage(String name) {
        Image image;
        int ndx = name.lastIndexOf(47);
        if (ndx >= 0) {
            name = name.substring(ndx + 1);
        }
        if ((ndx = name.lastIndexOf(46)) >= 0) {
            name = name.substring(0, ndx);
        }
        if ((image = this.imageMap.get(name)) == null) {
            for (String type : this.getExtensions()) {
                String url = this.imagePath + name + type;
                try (InputStream is = this.getClass().getResourceAsStream(url);){
                    if (is == null) continue;
                    image = new Image(is);
                    this.imageMap.put(name, image);
                    break;
                }
                catch (IOException ix) {
                    LOGGER.warning("closing input stream failed for " + url, (Throwable)ix);
                }
            }
            if (image == null) {
                throw new IllegalArgumentException("no such image '" + name + "'");
            }
        }
        return image;
    }
}

