/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxControl;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.ModelToViewListener;
import org.tentackle.fx.ViewToModelListener;

public abstract class FxControlDelegate
implements FxControl {
    private boolean viewModified;
    private BooleanProperty viewModifiedProperty;
    private boolean changeable = true;
    private ReadOnlyBooleanWrapper changeableProperty;
    private boolean containerChangeableIgnored;
    private boolean bindable = true;
    private String helpUrl;
    private Collection<ModelToViewListener> modelToViewListeners;
    private Collection<ViewToModelListener> viewToModelListeners;

    @Override
    public FxControlDelegate getDelegate() {
        return this;
    }

    @Override
    public void setViewModified(boolean viewModified) {
        if (this.viewModifiedProperty != null) {
            this.viewModifiedProperty.set(viewModified);
        } else {
            this.viewModified = viewModified;
        }
    }

    @Override
    public boolean isViewModified() {
        return this.viewModifiedProperty != null ? this.viewModifiedProperty.get() : this.viewModified;
    }

    @Override
    public BooleanProperty viewModifiedProperty() {
        if (this.viewModifiedProperty == null) {
            this.viewModifiedProperty = new SimpleBooleanProperty(this.viewModified);
        }
        return this.viewModifiedProperty;
    }

    @Override
    public void setChangeable(boolean changeable) {
        if (this.changeableProperty != null) {
            this.changeableProperty.set(changeable);
        }
        this.changeable = changeable;
        this.updateChangeable(changeable);
    }

    protected boolean isControlChangeable() {
        return this.changeable;
    }

    @Override
    public boolean isChangeable() {
        if (this.changeableProperty != null) {
            return this.changeableProperty.get();
        }
        return this.changeable;
    }

    @Override
    public ReadOnlyBooleanProperty changeableProperty() {
        if (this.changeableProperty == null) {
            this.changeableProperty = this.createChangeableProperty(this.changeable);
        }
        return this.changeableProperty.getReadOnlyProperty();
    }

    protected void updateChangeable(boolean changeable) {
    }

    protected ReadOnlyBooleanWrapper createChangeableProperty(boolean changeable) {
        return new ReadOnlyBooleanWrapper(changeable);
    }

    @Override
    public void setContainerChangableIgnored(boolean containerChangeableIgnored) {
        this.containerChangeableIgnored = containerChangeableIgnored;
    }

    @Override
    public boolean isContainerChangeableIgnored() {
        return this.containerChangeableIgnored;
    }

    @Override
    public void setBindable(boolean bindable) {
        this.bindable = bindable;
    }

    @Override
    public boolean isBindable() {
        return this.bindable;
    }

    @Override
    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    @Override
    public String getHelpUrl() {
        return this.helpUrl;
    }

    @Override
    public void showHelp() {
        FxUtilities.getInstance().showHelp(this);
    }

    @Override
    public void addModelToViewListener(ModelToViewListener listener) {
        this.getModelToViewListeners().add(listener);
    }

    @Override
    public void removeModelToViewListener(ModelToViewListener listener) {
        this.getModelToViewListeners().remove(listener);
    }

    @Override
    public void addViewToModelListener(ViewToModelListener listener) {
        this.getViewToModelListeners().add(listener);
    }

    @Override
    public void removeViewToModelListener(ViewToModelListener listener) {
        this.getViewToModelListeners().remove(listener);
    }

    public Collection<ModelToViewListener> getModelToViewListeners() {
        if (this.modelToViewListeners == null) {
            this.modelToViewListeners = new ArrayList<ModelToViewListener>();
        }
        return this.modelToViewListeners;
    }

    public void fireModelToViewListeners() {
        FxContainer parentContainer;
        if (this.modelToViewListeners != null) {
            for (ModelToViewListener listener : this.modelToViewListeners) {
                listener.modelChanged();
            }
        }
        if ((parentContainer = this.getParentContainer()) != null) {
            parentContainer.getDelegate().fireModelToViewListeners();
        }
    }

    public Collection<ViewToModelListener> getViewToModelListeners() {
        if (this.viewToModelListeners == null) {
            this.viewToModelListeners = new ArrayList<ViewToModelListener>();
        }
        return this.viewToModelListeners;
    }

    public void fireViewToModelListeners() {
        FxContainer parentContainer;
        if (this.viewToModelListeners != null) {
            for (ViewToModelListener listener : this.viewToModelListeners) {
                listener.viewChanged();
            }
        }
        if ((parentContainer = this.getParentContainer()) != null) {
            parentContainer.getDelegate().fireViewToModelListeners();
        }
    }
}

