/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import com.sun.javafx.css.StyleManager;
import java.awt.Desktop;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.print.PageLayout;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.transform.Scale;
import javafx.stage.PopupWindow;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.common.Service;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.CaseConversion;
import org.tentackle.fx.ErrorPopupSupported;
import org.tentackle.fx.Fx;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxControl;
import org.tentackle.fx.FxController;
import org.tentackle.fx.FxFxBundle;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.FxUtilitiesHolder;
import org.tentackle.fx.InfoPopupSupported;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.component.FxTextArea;
import org.tentackle.fx.component.Note;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.log.Logger;
import org.tentackle.misc.ConcurrencyHelper;

@Service(value=FxUtilities.class)
public class FxUtilities {
    private static final Logger LOGGER = Logger.get(FxUtilities.class);
    private final Executor blockingFxExecutor = ConcurrencyHelper.createBlockingExecutor(Platform::runLater);
    private String helpURL;
    private static final double XY_STEP_DIVISOR = 32.0;
    private static final int MAX_LOCATION_LOOP = 4;

    public static FxUtilities getInstance() {
        return FxUtilitiesHolder.INSTANCE;
    }

    public boolean isLenientMoneyInput(FxTextComponent component) {
        return false;
    }

    public int getDefaultTextAreaColumns(FxTextArea textArea) {
        return 30;
    }

    public long getPrefixSelectionTimeout() {
        return 500L;
    }

    public void showHelp(FxControl control) {
        if (control != null) {
            Object url = control.getHelpUrl();
            if (this.helpURL != null) {
                url = url != null ? this.helpURL + (String)url : this.helpURL;
            }
            if (url != null) {
                try {
                    Desktop.getDesktop().browse(URI.create((String)url));
                }
                catch (IOException | RuntimeException ex) {
                    Fx.error(MessageFormat.format(FxFxBundle.getString("CAN'T OPEN HELP FOR <{0}>"), url), ex);
                }
            }
        }
    }

    public Stage getStage(Node node) {
        Window window;
        Scene scene;
        Stage stage = null;
        if (node != null && (scene = node.getScene()) != null && (window = scene.getWindow()) instanceof Stage) {
            stage = (Stage)window;
        }
        return stage;
    }

    public boolean isModal(Stage stage) {
        boolean modal = false;
        if (stage != null) {
            switch (stage.getModality()) {
                case APPLICATION_MODAL: {
                    modal = true;
                    break;
                }
                case WINDOW_MODAL: {
                    modal = stage.getOwner() != null;
                    break;
                }
            }
        }
        return modal;
    }

    public void closeStageHierarchy(Node node, Stage stopStage) {
        Stage stage = this.getStage(node);
        while (stage != null && stage != stopStage) {
            stage.close();
            Window owner = stage.getOwner();
            if (!(owner instanceof Stage)) break;
            stage = (Stage)owner;
        }
    }

    public String dumpComponentHierarchy(Node node) {
        StringBuilder buf = new StringBuilder();
        buf.append(">>> component hierarchy within ");
        Stage stage = this.getStage(node);
        if (stage != null) {
            buf.append("stage '").append(stage.getTitle()).append("'");
        }
        while (node != null) {
            FxComponentBinding binding;
            TableConfiguration tableConfiguration;
            buf.append("\n    ");
            if (node instanceof FxContainer) {
                FxController controller = ((FxContainer)node).getController();
                if (controller != null) {
                    buf.append(controller.getClass().getName()).append(": ");
                }
            } else if (node instanceof FxTableView && (tableConfiguration = ((FxTableView)node).getConfiguration()) != null) {
                buf.append(tableConfiguration.getName()).append(": ");
            }
            buf.append(node).append(" @ [").append(node.getLayoutX()).append("/").append(node.getLayoutY()).append(']');
            if (node instanceof FxComponent && (binding = ((FxComponent)node).getBinding()) != null) {
                buf.append(" bound to ").append(binding.getMember());
            }
            node = node.getParent();
        }
        buf.append("\n<<<");
        return buf.toString();
    }

    public void runAndWait(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            throw new FxRuntimeException("calling thread is the FX application thread");
        }
        this.blockingFxExecutor.execute(runnable);
    }

    protected void setAlertMessage(Alert alert, String message) {
        alert.setHeaderText(null);
        Label textLabel = new Label();
        textLabel.setWrapText(false);
        textLabel.setText(message);
        alert.getDialogPane().setContent((Node)textLabel);
        alert.setResizable(true);
    }

    public Alert showInfoDialog(String message, String title) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(title == null ? FxFxBundle.getString("INFORMATION") : title);
        this.setAlertMessage(alert, message);
        alert.show();
        return alert;
    }

    public Alert showWarningDialog(String message, String title) {
        Alert alert = new Alert(Alert.AlertType.WARNING);
        alert.setTitle(title == null ? FxFxBundle.getString("WARNING") : title);
        this.setAlertMessage(alert, message);
        alert.show();
        return alert;
    }

    public Alert showQuestionDialog(String message, boolean defaultYes, String title, Consumer<Boolean> answer) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(title == null ? FxFxBundle.getString("QUESTION") : title);
        this.setAlertMessage(alert, message);
        alert.getButtonTypes().clear();
        alert.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        Button noButton = (Button)alert.getDialogPane().lookupButton(ButtonType.NO);
        Button yesButton = (Button)alert.getDialogPane().lookupButton(ButtonType.YES);
        noButton.setDefaultButton(!defaultYes);
        yesButton.setDefaultButton(defaultYes);
        alert.setOnHidden(e -> answer.accept(alert.getResult() == ButtonType.YES));
        alert.show();
        return alert;
    }

    public Alert showErrorDialog(String message, Throwable t, String title) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title == null ? FxFxBundle.getString("ERROR") : title);
        this.setAlertMessage(alert, message);
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            String exceptionText = sw.toString();
            Label label = new Label("STACKTRACE:");
            TextArea textArea = new TextArea(exceptionText);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            textArea.setMaxWidth(Double.MAX_VALUE);
            textArea.setMaxHeight(Double.MAX_VALUE);
            GridPane expContent = new GridPane();
            expContent.setMaxWidth(Double.MAX_VALUE);
            expContent.add((Node)label, 0, 0);
            expContent.add((Node)textArea, 0, 1);
            GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
            alert.getDialogPane().setExpandableContent((Node)expContent);
            alert.getDialogPane().expandedProperty().addListener(l -> Platform.runLater(() -> {
                alert.getDialogPane().requestLayout();
                Window w = alert.getDialogPane().getScene().getWindow();
                w.sizeToScene();
            }));
        }
        alert.show();
        return alert;
    }

    public PopupWindow showErrorPopup(ErrorPopupSupported component) {
        Note popup = null;
        String errorMessage = component.getError();
        if (!StringHelper.isAllWhitespace((String)errorMessage)) {
            Note note = new Note(Note.Position.RIGHT, Note.Type.ERROR);
            note.setText(errorMessage);
            note.show((Node)component);
            popup = note;
        }
        return popup;
    }

    public PopupWindow showInfoPopup(InfoPopupSupported component) {
        Note popup = null;
        String infoMessage = component.getInfo();
        if (!StringHelper.isAllWhitespace((String)infoMessage)) {
            Note note = new Note(Note.Position.RIGHT, Note.Type.INFO);
            note.setText(infoMessage);
            note.show((Node)component);
            popup = note;
        }
        return popup;
    }

    public void setupFocusHandling(Control control) {
        if (control instanceof FxComponent) {
            FxComponent component = (FxComponent)control;
            control.focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    FxUtilities.getInstance().focusGained(component);
                    component.showErrorPopup();
                } else {
                    FxUtilities.getInstance().focusLost(component);
                    component.hideErrorPopup();
                }
            });
            control.hoverProperty().addListener((observable, oldValue, newValue) -> {
                if (!control.isFocused()) {
                    if (newValue.booleanValue()) {
                        if (component.getError() == null) {
                            component.showInfoPopup();
                        }
                        component.showErrorPopup();
                    } else {
                        component.hideInfoPopup();
                        component.hideErrorPopup();
                    }
                }
            });
        }
    }

    public void focusGained(FxComponent component) {
        if (component.getError() == null) {
            component.updateView();
            if (component.isChangeable() && component instanceof FxTextComponent) {
                Platform.runLater(((FxTextComponent)component)::autoSelect);
            }
        }
    }

    public void focusLost(FxComponent component) {
        component.updateModel();
        if (component.isModelUpdated() && component.getError() == null) {
            component.updateView();
            ValueTranslator<?, ?> translator = component.getValueTranslator();
            if (translator != null && translator.needsToModelTwice()) {
                component.updateModel();
            }
        }
    }

    public void remapKeys(Control control) {
        final ArrayList mappedEvents = new ArrayList();
        control.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (mappedEvents.remove(event)) {
                    return;
                }
                if (KeyCode.ENTER == event.getCode()) {
                    KeyEvent newEvent = this.remap(event, KeyCode.TAB);
                    mappedEvents.add(newEvent);
                    event.consume();
                    Event.fireEvent((EventTarget)event.getTarget(), (Event)newEvent);
                }
            }

            private KeyEvent remap(KeyEvent event, KeyCode code) {
                KeyEvent newEvent = new KeyEvent(event.getEventType(), event.getCharacter(), event.getText(), code, event.isShiftDown(), event.isControlDown(), event.isAltDown(), event.isMetaDown());
                return newEvent.copyFor(event.getSource(), event.getTarget());
            }
        });
    }

    public void filterKeys(Control control) {
        if (control instanceof FxComponent) {
            control.addEventFilter(KeyEvent.ANY, event -> {
                FxComponent comp;
                if (event.getCode() == KeyCode.Z && event.isControlDown() && !event.isAltDown() && !event.isMetaDown() && !event.isShiftDown() && (comp = (FxComponent)control).isViewModified()) {
                    if (event.getEventType() == KeyEvent.KEY_PRESSED) {
                        comp.setViewObject(comp.getSavedViewObject());
                    }
                    event.consume();
                }
            });
        }
    }

    public void registerWindowEventFilters(Window window) {
        window.addEventFilter(MouseEvent.ANY, event -> {
            Node node;
            PickResult pickResult;
            if (event.isShiftDown() && event.isControlDown() && !event.isMetaDown() && !event.isAltDown() && event.isPopupTrigger() && (pickResult = event.getPickResult()) != null && (node = pickResult.getIntersectedNode()) != null) {
                LOGGER.info(() -> "\n" + this.dumpComponentHierarchy(node));
            }
        });
    }

    public void print(Node node) {
        PrinterJob job = PrinterJob.createPrinterJob();
        if (job != null && job.showPrintDialog((Window)Fx.getStage(node))) {
            PageLayout pageLayout = job.getJobSettings().getPageLayout();
            double scaleX = 1.0;
            if (pageLayout.getPrintableWidth() < node.getBoundsInParent().getWidth()) {
                scaleX = pageLayout.getPrintableWidth() / node.getBoundsInParent().getWidth();
            }
            double scaleY = 1.0;
            if (pageLayout.getPrintableHeight() < node.getBoundsInParent().getHeight()) {
                scaleY = pageLayout.getPrintableHeight() / node.getBoundsInParent().getHeight();
            }
            double scaleXY = Double.min(scaleX, scaleY);
            Scale scale = new Scale(scaleXY, scaleXY);
            node.getTransforms().add((Object)scale);
            boolean success = job.printPage(node);
            node.getTransforms().remove((Object)scale);
            if (success) {
                job.endJob();
            }
        }
    }

    public void addStyleSheet(String url) {
        StyleManager.getInstance().addUserAgentStylesheet(url);
    }

    public void addStyleSheets() {
        this.addStyleSheet("/org/tentackle/fx/tentackle.css");
    }

    public String getBindingOption(String options, String key) {
        String option = null;
        StringTokenizer stok = new StringTokenizer(options.toUpperCase(), ",");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken().trim();
            if (!token.startsWith(key)) continue;
            option = token;
            break;
        }
        return option;
    }

    public void applyBindingOptions(FxTextComponent comp, BindingMember member, String options) {
        this.applyBindingOptions(comp, null, member, options);
    }

    public void applyBindingOptions(TableColumnConfiguration columnConfiguration, BindingMember member, String options) {
        this.applyBindingOptions(null, columnConfiguration, member, options);
    }

    private void applyBindingOptions(FxTextComponent comp, TableColumnConfiguration columnConfiguration, BindingMember member, String options) {
        if (options != null) {
            StringTokenizer stok = new StringTokenizer(options.toUpperCase(), ",");
            while (stok.hasMoreTokens()) {
                boolean processed;
                String token = stok.nextToken().trim();
                if (comp != null) {
                    processed = this.applyBindingOption(comp, member, token);
                } else if (columnConfiguration != null) {
                    processed = this.applyBindingOption(columnConfiguration, member, token);
                } else {
                    throw new BindingException("unsupported @Bindable target " + member);
                }
                if (processed) continue;
                throw new BindingException("unsupported @Bindable option \"" + token + "\") in " + member);
            }
        }
    }

    protected boolean applyBindingOption(FxTextComponent comp, BindingMember member, String option) {
        boolean processed = false;
        if ("UC".equals(option)) {
            comp.setCaseConversion(CaseConversion.UPPER_CASE);
            processed = true;
        } else if ("LC".equals(option)) {
            comp.setCaseConversion(CaseConversion.LOWER_CASE);
            processed = true;
        } else if ("AUTOSELECT".equals(option)) {
            comp.setAutoSelect(true);
            processed = true;
        } else if ("-AUTOSELECT".equals(option)) {
            comp.setAutoSelect(false);
            processed = true;
        } else if ("UTC".equals(option)) {
            comp.setUTC(true);
            processed = true;
        } else if ("-UTC".equals(option)) {
            comp.setUTC(false);
            processed = true;
        } else if ("UNSIGNED".equals(option)) {
            comp.setUnsigned(true);
            processed = true;
        } else if ("-UNSIGNED".equals(option)) {
            comp.setUnsigned(false);
            processed = true;
        } else if ("DIGITS".equals(option)) {
            comp.setValidChars("0123456789");
            processed = true;
        } else if (option.startsWith("COLS=")) {
            try {
                comp.setColumns(Integer.parseInt(option.substring("COLS".length() + 1)));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid COLS @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
            }
        } else if (option.startsWith("MAXCOLS=")) {
            try {
                comp.setMaxColumns(Integer.parseInt(option.substring("MAXCOLS".length() + 1)));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid MAXCOLS @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
            }
        } else if (option.startsWith("SCALE=")) {
            try {
                comp.setScale(Integer.parseInt(option.substring("SCALE".length() + 1)));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid SCALE @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
            }
        } else if (option.startsWith("LINES=")) {
            if (comp instanceof TextArea) {
                try {
                    ((TextArea)comp).setPrefRowCount(Integer.parseInt(option.substring("LINES".length() + 1)));
                    processed = true;
                }
                catch (NumberFormatException ex) {
                    throw new BindingException("invalid LINES @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
                }
            } else {
                throw new BindingException("LINES @Bindable option \"" + option + "\") in " + member + " not applicable to " + comp.getClass().getName());
            }
        }
        return processed;
    }

    protected boolean applyBindingOption(TableColumnConfiguration columnConfiguration, BindingMember member, String option) {
        boolean processed = false;
        if ("UC".equals(option)) {
            columnConfiguration.setCaseConversion(Boolean.TRUE);
            processed = true;
        } else if ("LC".equals(option)) {
            columnConfiguration.setCaseConversion(Boolean.FALSE);
            processed = true;
        } else if ("AUTOSELECT".equals(option)) {
            columnConfiguration.setAutoSelect(Boolean.TRUE);
            processed = true;
        } else if ("-AUTOSELECT".equals(option)) {
            columnConfiguration.setAutoSelect(Boolean.FALSE);
            processed = true;
        } else if ("UNSIGNED".equals(option)) {
            columnConfiguration.setUnsigned(true);
            processed = true;
        } else if ("-UNSIGNED".equals(option)) {
            columnConfiguration.setUnsigned(false);
            processed = true;
        } else if ("DIGITS".equals(option)) {
            columnConfiguration.setValidChars("0123456789");
            processed = true;
        } else if (option.startsWith("MAXCOLS=")) {
            try {
                columnConfiguration.setMaxColumns(Integer.parseInt(option.substring("MAXCOLS".length() + 1)));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid MAXCOLS @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
            }
        } else if (option.startsWith("SCALE=")) {
            try {
                columnConfiguration.setScale(Integer.parseInt(option.substring("SCALE".length() + 1)));
                processed = true;
            }
            catch (NumberFormatException ex) {
                throw new BindingException("invalid SCALE @Bindable option \"" + option + "\") in " + member, (Throwable)ex);
            }
        } else if (option.startsWith("COLS=") || option.startsWith("LINES=")) {
            processed = true;
        }
        return processed;
    }

    public void resizeColumnsToFitContent(TableView<?> table) {
        TableViewSkin tableSkin = (TableViewSkin)table.getSkin();
        VirtualFlow virtualFlow = (VirtualFlow)tableSkin.getChildren().get(1);
        IndexedCell iCell = virtualFlow.getFirstVisibleCell();
        if (iCell != null) {
            int first = iCell.getIndex();
            iCell = virtualFlow.getLastVisibleCell();
            if (iCell != null) {
                int last = iCell.getIndex();
                for (TableColumn column : table.getColumns()) {
                    TableCell cell;
                    Callback cellFactory;
                    if (!column.isVisible() || (cellFactory = column.getCellFactory()) == null || (cell = (TableCell)cellFactory.call((Object)column)) == null) continue;
                    Font cellFont = cell.getFont();
                    Font headerFont = Font.font((String)cellFont.getFamily(), (FontWeight)FontWeight.BOLD, (double)cellFont.getSize());
                    cell.getProperties().put((Object)"deferToParentPrefWidth", (Object)Boolean.TRUE);
                    double maxWidth = 20.0;
                    cell.updateTableColumn(column);
                    cell.updateTableView(table);
                    cell.setText(column.getText());
                    cell.setGraphic(column.getGraphic());
                    cell.setFont(headerFont);
                    maxWidth = this.maxColumnWidth(maxWidth, cell, tableSkin);
                    cell.setFont(cellFont);
                    for (int row = first; row <= last; ++row) {
                        cell.updateIndex(row);
                        maxWidth = this.maxColumnWidth(maxWidth, cell, tableSkin);
                    }
                    table.resizeColumn(column, maxWidth - column.getWidth());
                }
            }
        }
    }

    public ObservableList<Stage> getAllShowingStages() {
        ObservableList stages = FXCollections.observableArrayList();
        Window.getWindows().forEach(w -> {
            if (w instanceof Stage) {
                stages.add((Object)((Stage)w));
            }
        });
        return stages;
    }

    public Point2D determineCenteredLocation(Window window) {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        double windowWidth = window.getWidth();
        double windowHeight = window.getHeight();
        if (window.getWidth() > screenSize.getWidth()) {
            windowWidth = screenSize.getWidth();
        }
        if (windowHeight > screenSize.getHeight()) {
            windowHeight = screenSize.getHeight();
        }
        return new Point2D((screenSize.getWidth() - windowWidth) / 2.0, (screenSize.getHeight() - windowHeight) / 2.0);
    }

    public Point2D determinePreferredStageLocation(Stage stage) {
        Point2D location = new Point2D(stage.getX(), stage.getY());
        if (location.getX() == 0.0 && location.getY() == 0.0) {
            Window owner = stage.getOwner();
            location = owner != null ? new Point2D(owner.getX() + (owner.getWidth() - stage.getWidth()) / 2.0, owner.getY() + (owner.getHeight() - stage.getHeight()) / 2.0) : this.determineCenteredLocation((Window)stage);
        }
        return this.determineAlignedStageLocation(stage, location);
    }

    public Point2D determineAlignedStageLocation(Stage stage, Point2D location) {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        double maxWidth = screenSize.getWidth() - screenSize.getWidth() / 32.0;
        double maxHeight = screenSize.getHeight() - screenSize.getHeight() / 32.0;
        double minX = screenSize.getWidth() / 32.0;
        double minY = screenSize.getHeight() / 32.0;
        if (location.getX() + stage.getWidth() > maxWidth) {
            location = new Point2D(maxWidth - stage.getWidth(), location.getY());
        }
        if (location.getX() < 0.0) {
            location = new Point2D(0.0, location.getY());
        } else if (location.getX() < minX && location.getX() + stage.getWidth() < maxWidth) {
            location = new Point2D(minX, location.getY());
        }
        if (location.getY() + stage.getHeight() > maxHeight) {
            location = new Point2D(location.getX(), maxHeight - stage.getHeight());
        }
        if (location.getY() < 0.0) {
            location = new Point2D(location.getX(), 0.0);
        } else if (location.getY() < minY && location.getY() + stage.getHeight() < maxHeight) {
            location = new Point2D(location.getX(), minY);
        }
        return this.determineFreeStageLocation(stage, location);
    }

    private double maxColumnWidth(double maxWidth, TableCell cell, TableViewSkin<?> tableSkin) {
        if (cell.getText() != null && !cell.getText().isEmpty() || cell.getGraphic() != null) {
            tableSkin.getChildren().add((Object)cell);
            cell.applyCss();
            maxWidth = Math.max(maxWidth, cell.prefWidth(-1.0));
            tableSkin.getChildren().remove((Object)cell);
        }
        return maxWidth;
    }

    private Point2D determineFreeStageLocation(Stage stage, Point2D startLocation) {
        Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
        double stepX = screenSize.getWidth() / 32.0;
        double stepY = screenSize.getHeight() / 32.0;
        double x = startLocation.getX() + stage.getWidth() / 2.0;
        double y = startLocation.getY() + stage.getHeight() / 2.0;
        double dx = x > screenSize.getWidth() / 2.0 ? -stepX : stepX;
        double dy = y > screenSize.getHeight() / 2.0 ? -stepY : stepY;
        for (int loop = 0; loop < 4; ++loop) {
            boolean abort = false;
            Point2D location = startLocation;
            while (!abort && this.isStageOverlapping(stage, location, dx, dy)) {
                if ((location = location.add(dx, dy)).getX() < 0.0) {
                    location = new Point2D(0.0, location.getY());
                    abort = true;
                }
                if (location.getX() + stage.getWidth() > screenSize.getWidth()) {
                    location = new Point2D(screenSize.getWidth() - stage.getWidth(), location.getY());
                    abort = true;
                }
                if (location.getY() < 0.0) {
                    location = new Point2D(location.getX(), 0.0);
                    abort = true;
                }
                if (!(location.getY() + stage.getHeight() > screenSize.getHeight())) continue;
                location = new Point2D(location.getX(), screenSize.getHeight() - stage.getHeight());
                abort = true;
            }
            if (!abort) {
                return location;
            }
            if (dx > 0.0 && dy > 0.0) {
                dx = -stepX;
                continue;
            }
            if (dx < 0.0 && dy > 0.0) {
                dy = -stepY;
                continue;
            }
            if (dx < 0.0 && dy < 0.0) {
                dx = stepX;
                continue;
            }
            if (!(dx > 0.0) || !(dy < 0.0)) continue;
            dy = stepY;
        }
        return startLocation;
    }

    private boolean isStageOverlapping(Stage stage, Point2D location, double dx, double dy) {
        Window owner = stage.getOwner();
        if (dx < 0.0) {
            dx = -dx;
        }
        if (dy < 0.0) {
            dy = -dy;
        }
        for (Stage w : this.getAllShowingStages()) {
            Window o = w.getOwner();
            if (w == stage || o != owner || !(location.getX() <= w.getX() + dx && location.getX() + stage.getWidth() + dx >= w.getX() + w.getWidth()) && (!(location.getY() <= w.getY() + dy) || !(location.getY() + stage.getHeight() + dy >= w.getY() + w.getHeight()))) continue;
            return true;
        }
        return false;
    }
}

