/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.apt;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import org.tentackle.apt.AbstractServiceAnnotationProcessor;
import org.tentackle.common.AnnotationProcessor;
import org.tentackle.fx.FxControllerService;

@SupportedAnnotationTypes(value={"org.tentackle.fx.FxControllerService"})
@AnnotationProcessor
public class FxControllerServiceAnnotationProcessor
extends AbstractServiceAnnotationProcessor {
    private final TypeVisitor<Boolean, Void> resourceBundleVisitor = new SimpleTypeVisitor8<Boolean, Void>(){

        @Override
        public Boolean visitExecutable(ExecutableType t, Void v) {
            List<? extends TypeMirror> typeList = t.getParameterTypes();
            return typeList.size() == 1 && FxControllerServiceAnnotationProcessor.this.typeUtils.erasure(typeList.get(0)).toString().equals("java.util.ResourceBundle");
        }
    };

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (TypeElement typeElement : annotations) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    this.processClass(element);
                }
            }
        }
        return true;
    }

    protected void processClass(Element element) {
        super.processClass(element);
        FxControllerService fxControllerService = element.getAnnotation(FxControllerService.class);
        if (!"NONE".equals(fxControllerService.url()) || "NONE".equals(fxControllerService.resources())) {
            if (!this.verifyConstructor(element, (TypeVisitor)this.noArgsVisitor)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "class " + element + " needs a no-args constructor", element);
            }
        } else if (!this.verifyConstructor(element, this.resourceBundleVisitor)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "class " + element + " needs constructor (ResourceBundle)", element);
        }
        this.verifyImplements(element, "org.tentackle.fx.FxController");
    }
}

