/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.bind;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tentackle.bind.AbstractBinding;
import org.tentackle.bind.Binder;
import org.tentackle.bind.BindingMember;
import org.tentackle.bind.BindingVetoException;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.bind.FxComponentBinder;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.log.Logger;
import org.tentackle.validate.ChangeableBindingEvaluator;
import org.tentackle.validate.MandatoryBindingEvaluator;
import org.tentackle.validate.ValidationContext;
import org.tentackle.validate.ValidationScope;
import org.tentackle.validate.ValidationScopeFactory;
import org.tentackle.validate.Validator;
import org.tentackle.validate.scope.MandatoryScope;

public class DefaultFxComponentBinding
extends AbstractBinding
implements FxComponentBinding {
    private static final Logger LOGGER = Logger.get(DefaultFxComponentBinding.class);
    private List<Validator> fixedMandatoryValidators;
    private List<Validator> fixedChangeableValidators;
    private FxComponent component;

    public DefaultFxComponentBinding(FxComponentBinder binder, BindingMember[] parents, BindingMember member, FxComponent component, String componentOptions) {
        super((Binder)binder, parents, member);
        this.component = Objects.requireNonNull(component, "component");
        this.updateComponentName();
        component.setBinding(this);
        if (component instanceof FxTextComponent) {
            FxUtilities.getInstance().applyBindingOptions((FxTextComponent)component, member, componentOptions);
        }
        this.determineValidators();
        this.applyType();
    }

    @Override
    public FxComponentBinder getBinder() {
        return (FxComponentBinder)super.getBinder();
    }

    @Override
    public FxComponent getComponent() {
        return this.component;
    }

    public Object getViewValue() {
        return this.component.getViewValue();
    }

    public void fireToView(Object parent, Object modelValue) throws BindingVetoException {
        ValidationContext validationContext;
        MandatoryScope scope;
        super.fireToView(parent, modelValue);
        if (this.fixedMandatoryValidators != null && !this.fixedMandatoryValidators.isEmpty()) {
            boolean mandatory = false;
            for (Validator validator : this.fixedMandatoryValidators) {
                if (parent == null || !(scope = ValidationScopeFactory.getInstance().getMandatoryScope()).appliesTo(validator.getConfiguredScopes(validationContext = new ValidationContext(this.getMember().getMemberPath(), this.getMember().getType(), modelValue, parent, (ValidationScope)scope))) || !validator.isConditionValid(validationContext) || !((MandatoryBindingEvaluator)validator).isMandatory(validationContext)) continue;
                mandatory = true;
                break;
            }
            this.setMandatory(mandatory);
        }
        if (this.fixedChangeableValidators != null && !this.fixedChangeableValidators.isEmpty()) {
            boolean changeable = false;
            for (Validator validator : this.fixedChangeableValidators) {
                if (parent == null || !(scope = ValidationScopeFactory.getInstance().getChangeableScope()).appliesTo(validator.getConfiguredScopes(validationContext = new ValidationContext(this.getMember().getMemberPath(), this.getMember().getType(), modelValue, parent, (ValidationScope)scope))) || !validator.isConditionValid(validationContext) || !((ChangeableBindingEvaluator)validator).isChangeable(validationContext)) continue;
                changeable = true;
                break;
            }
            this.setChangeable(changeable);
        }
    }

    protected void determineValidators() {
        super.determineValidators();
        List validators = this.getValidators();
        if (validators != null) {
            for (Validator validator : validators) {
                if (validator instanceof MandatoryBindingEvaluator && !((MandatoryBindingEvaluator)validator).isMandatoryDynamic()) {
                    if (this.fixedMandatoryValidators == null) {
                        this.fixedMandatoryValidators = new ArrayList<Validator>();
                    }
                    this.fixedMandatoryValidators.add(validator);
                }
                if (!(validator instanceof ChangeableBindingEvaluator) || ((ChangeableBindingEvaluator)validator).isChangeableDynamic()) continue;
                if (this.fixedChangeableValidators == null) {
                    this.fixedChangeableValidators = new ArrayList<Validator>();
                }
                this.fixedChangeableValidators.add(validator);
            }
        }
    }

    protected Class<?> getViewType() {
        return this.component.getType();
    }

    protected void applyType() {
        this.component.setGenericType(this.getMember().getGenericType());
        this.component.setType(this.getMember().getType());
        if (this.getMember().isReadOnly()) {
            this.component.setChangeable(false);
        }
    }

    protected void updateComponentName() {
        if (this.component instanceof Component && ((Component)((Object)this.component)).getName() == null) {
            StringBuilder buf = new StringBuilder(this.getMember().getMemberPath());
            for (Container parent = ((Component)((Object)this.component)).getParent(); parent != null; parent = parent.getParent()) {
                if (parent.getName() == null) continue;
                buf.insert(0, parent.getName() + "/");
            }
            ((Component)((Object)this.component)).setName(buf.toString());
            LOGGER.fine("{0}.setName(\"{1}\")", new Object[]{this.component.getComponentPath(), ((Component)((Object)this.component)).getName()});
        }
    }

    public void setMandatory(boolean mandatory) {
        this.component.setMandatory(mandatory);
    }

    public boolean isMandatory() {
        return this.component.isMandatory();
    }

    public void setChangeable(boolean changeable) {
        this.component.setChangeable(changeable);
    }

    public boolean isChangeable() {
        return this.component.isChangeable();
    }

    protected Object getBoundRootObject() {
        return this.getBinder().getController();
    }

    protected boolean isValidationRequired() {
        return true;
    }

    protected String viewComponentToString() {
        return this.component.getComponentPath();
    }

    protected void updateView(Object value) {
        this.component.setViewValue(value);
    }
}

