/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.config;

import javafx.scene.control.DatePicker;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tentackle.fx.ConfiguratorService;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.component.config.ComponentConfigurator;

@ConfiguratorService(value=DatePicker.class)
public class DatePickerConfigurator<T extends DatePicker>
extends ComponentConfigurator<T> {
    @Override
    public void configure(T control) {
        super.configure(control);
        control.getEditor().textProperty().addListener(o -> ((FxComponent)control).triggerViewModified());
        control.addEventFilter(KeyEvent.ANY, event -> {
            if (event.getCode() == KeyCode.BACK_SPACE && event.isShiftDown() && !event.isControlDown() && !event.isAltDown() && !event.isMetaDown()) {
                if (event.getEventType() == KeyEvent.KEY_PRESSED && !control.getEditor().isDisabled() && control.getEditor().isEditable()) {
                    control.getEditor().clear();
                }
                event.consume();
            }
        });
    }
}

