/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import javafx.scene.Parent;
import org.tentackle.fx.FxComponentDelegate;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.component.FxCheckBox;

public class FxCheckBoxDelegate
extends FxComponentDelegate {
    private final FxCheckBox component;

    public FxCheckBoxDelegate(FxCheckBox component) {
        this.component = component;
    }

    @Override
    public FxCheckBox getComponent() {
        return this.component;
    }

    @Override
    public FxContainer getParentContainer() {
        Parent parent = this.component.getParent();
        return parent instanceof FxContainer ? (FxContainer)parent : null;
    }

    @Override
    public void setType(Class<?> type) {
        super.setType(type);
        if (this.getValueTranslator() == null) {
            this.setValueTranslator(FxFactory.getInstance().createValueTranslator(type, Boolean.class, this.getComponent()));
        }
        this.component.setAllowIndeterminate(Boolean.TYPE != type);
    }

    @Override
    public Boolean getViewObject() {
        if (this.component.isIndeterminate()) {
            return null;
        }
        return this.component.isSelected();
    }

    @Override
    public void setViewObject(Object viewObject) {
        if (viewObject == null && this.component.isAllowIndeterminate()) {
            this.component.setIndeterminate(true);
        } else {
            this.component.setSelected(viewObject != null && (Boolean)viewObject != false);
        }
    }

    @Override
    public void setViewValue(Object value) {
        ValueTranslator<?, ?> translator = this.getValueTranslator();
        this.setViewObject(translator.toView(value));
    }

    @Override
    public <V> V getViewValue() {
        ValueTranslator<?, ?> translator = this.getValueTranslator();
        return (V)translator.toModel(this.getViewObject());
    }
}

