/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import java.util.Arrays;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tentackle.fx.FxComponentDelegate;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.component.FxChoiceBox;

public class FxChoiceBoxDelegate
extends FxComponentDelegate {
    private final FxChoiceBox<?> component;

    public FxChoiceBoxDelegate(FxChoiceBox<?> component) {
        this.component = component;
    }

    @Override
    public FxChoiceBox<?> getComponent() {
        return this.component;
    }

    @Override
    public FxContainer getParentContainer() {
        Parent parent = this.component.getParent();
        return parent instanceof FxContainer ? (FxContainer)parent : null;
    }

    @Override
    public void setType(Class<?> type) {
        super.setType(type);
        this.component.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (!(event.isAltDown() || event.isControlDown() || event.isMetaDown() || event.isShortcutDown() || event.getCode() != KeyCode.DELETE && event.getCode() != KeyCode.BACK_SPACE || this.component.isDisabled() || !this.isDeselectAllowed())) {
                event.consume();
                this.component.getSelectionModel().clearSelection();
            }
        });
        if (type.isEnum()) {
            ObservableList items = this.component.getItems();
            items.clear();
            items.addAll(Arrays.asList(type.getEnumConstants()));
        }
    }

    @Override
    public void setViewObject(Object value) {
        this.component.getSelectionModel().select(value);
    }

    @Override
    public Object getViewObject() {
        return this.component.getSelectionModel().getSelectedItem();
    }

    @Override
    public void setViewValue(Object value) {
        this.setViewObject(value);
    }

    @Override
    public <V> V getViewValue() {
        return (V)this.getViewObject();
    }

    public boolean isDeselectAllowed() {
        Boolean allowed = this.component.isDeselectAllowed();
        if (allowed != null) {
            return allowed;
        }
        return (this.getType() == null || !this.getType().isPrimitive()) && !this.component.isMandatory();
    }
}

