/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import javafx.collections.ObservableList;
import javafx.scene.Parent;
import org.tentackle.fx.FxComponentDelegate;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.component.FxListView;

public class FxListViewDelegate
extends FxComponentDelegate {
    private final FxListView<?> component;

    public FxListViewDelegate(FxListView<?> component) {
        this.component = component;
    }

    @Override
    public FxListView<?> getComponent() {
        return this.component;
    }

    @Override
    public FxContainer getParentContainer() {
        Parent parent = this.component.getParent();
        return parent instanceof FxContainer ? (FxContainer)parent : null;
    }

    @Override
    public void setType(Class<?> type) {
        super.setType(type);
        if (this.getValueTranslator() == null) {
            this.setValueTranslator(FxFactory.getInstance().createValueTranslator(type, ObservableList.class, this.getComponent()));
        }
    }

    public ObservableList getViewObject() {
        return this.component.getItems();
    }

    @Override
    public void setViewObject(Object viewObject) {
        this.component.setItems((ObservableList)viewObject);
    }

    @Override
    public void setViewValue(Object value) {
        ValueTranslator<?, ?> translator = this.getValueTranslator();
        this.setViewObject(translator.toView(value));
    }

    @Override
    public <V> V getViewValue() {
        ValueTranslator<?, ?> translator = this.getValueTranslator();
        return (V)translator.toModel(this.getViewObject());
    }
}

