/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import javafx.geometry.Pos;
import javafx.scene.control.TextFormatter;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.component.FxPasswordField;
import org.tentackle.fx.component.delegate.AbstractTextFieldDelegate;

public class FxPasswordFieldDelegate
extends AbstractTextFieldDelegate<FxPasswordField> {
    private boolean setColumnsInvoked;

    public FxPasswordFieldDelegate(FxPasswordField component) {
        super(component);
    }

    @Override
    protected ValueTranslator<?, ?> createValueTranslator(Class<?> type) {
        return char[].class == type ? FxFactory.getInstance().createValueTranslator(type, char[].class, (FxComponent)this.getComponent()) : super.createValueTranslator(type);
    }

    @Override
    public TextFormatter.Change apply(TextFormatter.Change t) {
        if (this.isCharArray()) {
            return t;
        }
        return super.apply(t);
    }

    @Override
    public Object getViewObject() {
        if (this.isCharArray()) {
            return ((FxPasswordField)this.getComponent()).getPassword();
        }
        String text = ((FxPasswordField)this.getComponent()).getText();
        return StringHelper.isAllWhitespace((String)text) ? null : text;
    }

    @Override
    public void setViewObject(Object viewObject) {
        if (viewObject instanceof char[]) {
            ((FxPasswordField)this.getComponent()).setPassword((char[])viewObject);
        } else {
            ((FxPasswordField)this.getComponent()).setText((String)viewObject);
        }
    }

    @Override
    public void setColumns(int columns) {
        ((FxPasswordField)this.getComponent()).setPrefColumnCount(columns);
        this.setColumnsInvoked = true;
    }

    @Override
    public int getColumns() {
        return ((FxPasswordField)this.getComponent()).getPrefColumnCount();
    }

    @Override
    public void setMaxColumns(int maxColumns) {
        super.setMaxColumns(maxColumns);
        if (!this.setColumnsInvoked) {
            ((FxPasswordField)this.getComponent()).setPrefColumnCount(maxColumns);
        }
    }

    @Override
    public void setViewValue(Object value) {
        super.setViewValue(value);
        Pos alignment = this.getTextAlignment();
        if (alignment != null && ((FxPasswordField)this.getComponent()).getAlignment() != alignment) {
            ((FxPasswordField)this.getComponent()).setAlignment(alignment);
        }
    }

    @Override
    public void updateModel() {
        if (this.isCharArray() && this.getBinding() != null) {
            StringHelper.blank((char[])((char[])this.getBinding().getModelValue()));
        }
        super.updateModel();
    }

    private boolean isCharArray() {
        return this.getType() == null ? false : char[].class == this.getType();
    }
}

