/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import javafx.scene.Parent;
import javafx.scene.control.TreeItem;
import org.tentackle.fx.FxComponentDelegate;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.component.FxTreeView;

public class FxTreeViewDelegate
extends FxComponentDelegate {
    private final FxTreeView<?> component;

    public FxTreeViewDelegate(FxTreeView<?> component) {
        this.component = component;
    }

    @Override
    public FxTreeView<?> getComponent() {
        return this.component;
    }

    @Override
    public FxContainer getParentContainer() {
        Parent parent = this.component.getParent();
        return parent instanceof FxContainer ? (FxContainer)parent : null;
    }

    @Override
    public void setType(Class<?> type) {
        super.setType(type);
        if (this.getValueTranslator() == null) {
            this.setValueTranslator(FxFactory.getInstance().createValueTranslator(type, TreeItem.class, this.getComponent()));
        }
    }

    public TreeItem getViewObject() {
        return this.component.getRoot();
    }

    @Override
    public void setViewObject(Object viewObject) {
        this.component.setRoot((TreeItem)viewObject);
    }

    @Override
    public void setViewValue(Object value) {
        ValueTranslator<?, ?> translator = this.getValueTranslator();
        this.setViewObject(translator.toView(value));
    }

    @Override
    public <V> V getViewValue() {
        ValueTranslator<?, ?> translator = this.getValueTranslator();
        return (V)translator.toModel(this.getViewObject());
    }
}

