/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.skin;

import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.stage.Window;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.component.Note;

public class NoteSkin
implements Skin<Note> {
    private static final double LINE_LENGTH = 15.0;
    private static final double CIRCLE_RADIUS = 3.0;
    private final Note note;
    private final Node linkedNode;
    private final StackPane rootPane;

    public NoteSkin(Note note) {
        this.note = note;
        this.rootPane = note.getRootPane();
        this.linkedNode = note.getOwnerNode();
        if (this.linkedNode == null) {
            throw new FxRuntimeException("owner node not set");
        }
        Bindings.bindContent((List)this.rootPane.getStyleClass(), (ObservableList)note.getStyleClass());
        Node link = this.createLink(note.getPosition());
        switch (note.getPosition()) {
            case BOTTOM: {
                VBox bottomNote = new VBox();
                bottomNote.setAlignment(Pos.CENTER);
                bottomNote.getChildren().add((Object)link);
                bottomNote.getChildren().add((Object)note.getContentNode());
                bottomNote.getStyleClass().add((Object)"box");
                this.rootPane.getChildren().add((Object)bottomNote);
                break;
            }
            case TOP: {
                VBox topNote = new VBox();
                topNote.setAlignment(Pos.CENTER);
                topNote.getChildren().add((Object)note.getContentNode());
                topNote.getChildren().add((Object)link);
                topNote.getStyleClass().add((Object)"box");
                this.rootPane.getChildren().add((Object)topNote);
                break;
            }
            case LEFT: {
                HBox leftNote = new HBox();
                leftNote.setAlignment(Pos.CENTER);
                leftNote.getChildren().add((Object)note.getContentNode());
                leftNote.getChildren().add((Object)link);
                leftNote.getStyleClass().add((Object)"box");
                this.rootPane.getChildren().add((Object)leftNote);
                break;
            }
            default: {
                HBox rightNote = new HBox();
                rightNote.setSpacing(0.0);
                rightNote.setAlignment(Pos.CENTER);
                rightNote.getChildren().add((Object)link);
                rightNote.getChildren().add((Object)note.getContentNode());
                rightNote.getStyleClass().add((Object)"box");
                this.rootPane.getChildren().add((Object)rightNote);
            }
        }
        Window ownerWindow = this.linkedNode.getScene().getWindow();
        ownerWindow.xProperty().addListener((InvalidationListener)new WeakInvalidationListener(o -> this.updateLocation()));
        ownerWindow.yProperty().addListener((InvalidationListener)new WeakInvalidationListener(o -> this.updateLocation()));
        note.setOnShown(e -> this.updateLocation());
    }

    public Note getSkinnable() {
        return this.note;
    }

    public StackPane getNode() {
        return this.rootPane;
    }

    public void dispose() {
    }

    protected void updateLocation() {
        Bounds linkedNodeBounds = this.linkedNode.localToScreen(this.linkedNode.getBoundsInLocal());
        Point2D linkedNodeLocation = this.linkedNode.localToScreen(0.0, 0.0);
        if (linkedNodeBounds != null && linkedNodeLocation != null) {
            switch (this.note.getPosition()) {
                case BOTTOM: {
                    this.note.setAnchorX(linkedNodeLocation.getX() + linkedNodeBounds.getWidth() / 2.0 - this.note.getWidth() / 2.0);
                    this.note.setAnchorY(linkedNodeLocation.getY() + linkedNodeBounds.getHeight() - 3.0);
                    break;
                }
                case TOP: {
                    this.note.setAnchorX(linkedNodeLocation.getX() + linkedNodeBounds.getWidth() / 2.0 - this.note.getWidth() / 2.0);
                    this.note.setAnchorY(linkedNodeLocation.getY() - this.note.getHeight() + 3.0);
                    break;
                }
                case LEFT: {
                    this.note.setAnchorX(linkedNodeLocation.getX() - this.note.getWidth() + 3.0);
                    this.note.setAnchorY(linkedNodeLocation.getY() + linkedNodeBounds.getHeight() / 2.0 - this.note.getHeight() / 2.0);
                    break;
                }
                default: {
                    this.note.setAnchorX(linkedNodeLocation.getX() + linkedNodeBounds.getWidth() - 3.0);
                    this.note.setAnchorY(linkedNodeLocation.getY() + linkedNodeBounds.getHeight() / 2.0 - this.note.getHeight() / 2.0);
                }
            }
        }
    }

    protected Node createLink(Note.Position alignment) {
        Circle circle = new Circle();
        circle.getStyleClass().add((Object)"circle");
        circle.setRadius(3.0);
        Line line = new Line();
        line.getStyleClass().add((Object)"line");
        switch (alignment) {
            case BOTTOM: {
                circle.setCenterX(3.0);
                circle.setCenterY(3.0);
                line.setStartX(3.0);
                line.setStartY(3.0);
                line.setEndX(3.0);
                line.setEndY(18.0);
                break;
            }
            case TOP: {
                line.setStartX(3.0);
                line.setStartY(0.0);
                line.setEndX(3.0);
                line.setEndY(15.0);
                circle.setCenterX(3.0);
                circle.setCenterY(18.0);
                break;
            }
            case LEFT: {
                line.setStartX(0.0);
                line.setStartY(3.0);
                line.setEndX(15.0);
                line.setEndY(3.0);
                circle.setCenterX(18.0);
                circle.setCenterY(3.0);
                break;
            }
            default: {
                circle.setCenterX(3.0);
                circle.setCenterY(3.0);
                line.setStartX(3.0);
                line.setStartY(3.0);
                line.setEndX(18.0);
                line.setEndY(3.0);
            }
        }
        Group group = new Group();
        group.getStyleClass().add((Object)"link");
        group.getChildren().add((Object)circle);
        group.getChildren().add((Object)line);
        return group;
    }
}

