/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import org.tentackle.common.Service;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.table.TableCellType;
import org.tentackle.fx.table.TableCellTypeFactory;
import org.tentackle.reflect.ClassMapper;
import org.tentackle.reflect.ReflectionHelper;

@Service(value=TableCellTypeFactory.class)
public class DefaultTableCellTypeFactory
implements TableCellTypeFactory {
    private final ConcurrentHashMap<Class<?>, TableCellType<?>> cellTypeMap = new ConcurrentHashMap();
    private final ClassMapper cellTypeMapper = ClassMapper.create((String)"table cell type", TableCellType.class);

    @Override
    public <T> TableCellType<T> getTableCellType(Class<T> itemClass) {
        Class clazz = itemClass.isPrimitive() ? ReflectionHelper.primitiveToWrapperClass(itemClass) : itemClass;
        TableCellType cellType = this.cellTypeMap.get(clazz);
        if (cellType == null) {
            try {
                Class cellTypeClass = this.cellTypeMapper.mapLenient(clazz);
                cellType = (TableCellType)cellTypeClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.cellTypeMap.put(itemClass, cellType);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                throw new FxRuntimeException("cannot load table cell type for " + itemClass, ex);
            }
        }
        return cellType;
    }
}

