/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.table.type;

import java.text.DateFormat;
import java.util.Date;
import javafx.geometry.Pos;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.fx.table.TableCellTypeService;
import org.tentackle.fx.table.type.AbstractTableCellType;

@TableCellTypeService(value=Date.class)
public class UtilDateTableCellType<T extends Date>
extends AbstractTableCellType<T> {
    @Override
    public void updateItem(FxTableCell<?, T> tableCell, T item) {
        tableCell.setGraphic(null);
        DateFormat fmt = this.getFormat(tableCell);
        String text = fmt != null ? fmt.format((Date)item) : ((Date)item).toString();
        tableCell.setText(text);
        this.updateAlignment(tableCell, Pos.CENTER);
    }

    protected DateFormat getFormat(FxTableCell<?, T> tableCell) {
        return tableCell.getColumnConfiguration().getDateFormat();
    }
}

