/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.util.function.Function;
import org.tentackle.fx.FxTextComponent;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.translate.AbstractValueTranslator;

@ValueTranslatorService(modelClass=Enum.class, viewClass=String.class)
public class EnumStringTranslator<T extends Enum<T>>
extends AbstractValueTranslator<T, String> {
    private final Class<T> clazz;

    public EnumStringTranslator(FxTextComponent component, Class<T> clazz) {
        super(component);
        this.clazz = clazz;
    }

    @Override
    public Function<T, String> toViewFunction() {
        return v -> v == null ? null : v.toString();
    }

    @Override
    public Function<String, T> toModelFunction() {
        return s -> {
            if (s != null) {
                for (Enum v : (Enum[])this.clazz.getEnumConstants()) {
                    if (!s.equals(v.toString())) continue;
                    return v;
                }
            }
            return null;
        };
    }
}

