/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.translate;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.tentackle.bind.BindableType;
import org.tentackle.common.BundleFactory;
import org.tentackle.common.LocaleProvider;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxFactory;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.ValueTranslatorService;
import org.tentackle.fx.component.FxTableView;
import org.tentackle.fx.table.TableConfiguration;
import org.tentackle.fx.translate.AbstractValueTranslator;

@ValueTranslatorService(modelClass=List.class, viewClass=ObservableList.class)
public class ObservableListTranslator<T, C extends List<T>>
extends AbstractValueTranslator<C, ObservableList<T>> {
    public ObservableListTranslator(FxComponent component) {
        super(component);
        Type[] typeArguments;
        Type genType;
        if (component instanceof FxTableView && (genType = component.getGenericType()) instanceof ParameterizedType && (typeArguments = ((ParameterizedType)genType).getActualTypeArguments()) != null && typeArguments.length == 1) {
            this.configureTableView((FxTableView)component, (Class)typeArguments[0]);
        }
    }

    @Override
    public Function<C, ObservableList<T>> toViewFunction() {
        return m -> {
            ObservableList items;
            ObservableList observableList = m instanceof ObservableList ? (ObservableList)m : (items = m == null ? FXCollections.emptyObservableList() : FXCollections.observableList((List)m));
            if (this.getComponent() instanceof TableView) {
                boolean sortable = false;
                for (TableColumn column : ((TableView)this.getComponent()).getColumns()) {
                    if (!column.isSortable()) continue;
                    sortable = true;
                    break;
                }
                if (sortable && !(items instanceof SortedList)) {
                    SortedList sortedResult = new SortedList(items);
                    sortedResult.comparatorProperty().bind((ObservableValue)((TableView)this.getComponent()).comparatorProperty());
                    items = sortedResult;
                }
            }
            return items;
        };
    }

    @Override
    public Function<ObservableList<T>, C> toModelFunction() {
        throw new FxRuntimeException("conversion to model is not applicable to lists");
    }

    protected void configureTableView(FxTableView<T> tableView, Class<T> elemClass) {
        BindableType bindableType = elemClass.getAnnotation(BindableType.class);
        if (bindableType != null) {
            ResourceBundle bundle = null;
            String bundleName = bindableType.resources();
            if (bundleName.isEmpty()) {
                bundleName = elemClass.getName();
            }
            if (!"NONE".equals(bundleName)) {
                bundle = BundleFactory.getBundle((String)bundleName, (Locale)LocaleProvider.getInstance().getLocale());
            }
            TableConfiguration<T> configuration = FxFactory.getInstance().createTableConfiguration(elemClass, (String)null);
            configuration.addBindableColumns(elemClass, bindableType.declaredOnly(), bundle);
            if (bindableType.declaredOnly()) {
                configuration.getBinder().bind();
            } else {
                configuration.getBinder().bindAllInherited();
            }
            configuration.getBinder().assertAllBound();
            configuration.configure(tableView);
        }
    }
}

