/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.PopupWindow;
import org.tentackle.bind.BindingVetoException;
import org.tentackle.common.ExceptionHelper;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxControlDelegate;
import org.tentackle.fx.FxRuntimeException;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.bind.FxComponentBinding;
import org.tentackle.fx.table.FxTableCell;
import org.tentackle.log.Logger;
import org.tentackle.validate.ValidationFailedException;

public abstract class FxComponentDelegate
extends FxControlDelegate
implements FxComponent {
    public static final String MANDATORY_STYLE = "tt-mandatory";
    public static final String ERROR_STYLE = "tt-error";
    public static final String INFO_STYLE = "tt-info";
    private static final Logger LOGGER = Logger.get(FxComponentDelegate.class);
    private Class<?> type;
    private Type genericType;
    private ValueTranslator<?, ?> valueTranslator;
    private boolean mandatory;
    private BooleanProperty mandatoryProperty;
    private String bindingPath;
    private FxComponentBinding binding;
    private String componentPath;
    private Object savedViewObject;
    private boolean savedViewObjectValid;
    private String errorMessage;
    private boolean errorTemporary;
    private PopupWindow errorPopup;
    private String infoMessage;
    private PopupWindow infoPopup;
    private boolean modelUpdated;
    private boolean updatingModel;
    private boolean updatingView;
    private FxTableCell<?, ?> tableCell;

    @Override
    public FxComponentDelegate getDelegate() {
        return this;
    }

    public abstract FxComponent getComponent();

    public Node getNode() {
        return (Node)this.getComponent();
    }

    @Override
    public FxContainer getParentContainer() {
        Parent parent = ((Node)this.getComponent()).getParent();
        return parent instanceof FxContainer ? (FxContainer)parent : null;
    }

    @Override
    public String toGenericString() {
        StringBuilder buf = new StringBuilder();
        buf.append("component ").append(this.getComponent().getClass().getName());
        String id = ((Node)this.getComponent()).getId();
        if (id != null) {
            buf.append('[').append(id).append(']');
        }
        return buf.toString();
    }

    public String toString() {
        return "delegate for " + this.toGenericString();
    }

    @Override
    protected void updateChangeable(boolean changeable) {
        this.getNode().setDisable(!changeable);
        this.getNode().setFocusTraversable(changeable);
        this.updateMandatoryStyle(this.isMandatory());
        this.updateInfoStyle(changeable && this.infoMessage != null);
        this.updateErrorStyle(changeable && this.errorMessage != null);
    }

    @Override
    protected ReadOnlyBooleanWrapper createChangeableProperty(boolean changeable) {
        ReadOnlyBooleanWrapper changeableProperty = new ReadOnlyBooleanWrapper(changeable);
        changeableProperty.bind((ObservableValue)this.getNode().disabledProperty().not());
        return changeableProperty;
    }

    @Override
    public void setContainerChangeable(boolean containerChangeable) {
        if (!this.isContainerChangeableIgnored()) {
            this.getNode().setDisable(!containerChangeable || !this.isControlChangeable());
            this.updateMandatoryStyle(this.isMandatory());
            this.updateInfoStyle(containerChangeable && this.infoMessage != null);
            this.updateErrorStyle(containerChangeable && this.errorMessage != null);
        }
    }

    @Override
    public void setValueTranslator(ValueTranslator<?, ?> valueTranslator) {
        if (this.valueTranslator != null) {
            throw new FxRuntimeException("value translator already set");
        }
        this.valueTranslator = valueTranslator;
    }

    @Override
    public ValueTranslator<?, ?> getValueTranslator() {
        return this.valueTranslator;
    }

    protected boolean isUpdatingModel() {
        return this.updatingModel;
    }

    protected boolean isUpdatingView() {
        return this.updatingView;
    }

    @Override
    public void updateView() {
        if (!this.updatingView) {
            try {
                this.updatingView = true;
                this.modelUpdated = false;
                this.fireModelToViewListeners();
                if (this.binding != null) {
                    this.binding.setViewValue(this.binding.getModelValue());
                }
            }
            finally {
                this.updatingView = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateModel() {
        block13: {
            if (!this.updatingModel) {
                try {
                    block14: {
                        this.updatingModel = true;
                        if (this.getNode().isDisabled()) break block13;
                        try {
                            String oldError = this.getError();
                            if (this.binding != null) {
                                this.binding.setModelValue(this.binding.getViewValue());
                                List results = this.binding.validate();
                                if (!results.isEmpty()) {
                                    throw new ValidationFailedException(results);
                                }
                            }
                            this.fireViewToModelListeners();
                            this.modelUpdated = true;
                            if (this.getError() != null && !this.getError().equals(oldError)) {
                                this.handleInputFailure(this.getError());
                            }
                        }
                        catch (RuntimeException rex) {
                            String msg;
                            if (this.getError() != null) break block14;
                            ValidationFailedException vx = (ValidationFailedException)ExceptionHelper.extractException(ValidationFailedException.class, (boolean)true, (Throwable)rex);
                            if (vx == null) {
                                BindingVetoException bve = (BindingVetoException)ExceptionHelper.extractException(BindingVetoException.class, (boolean)true, (Throwable)rex);
                                if (bve == null) {
                                    LOGGER.severe("update model failed for " + FxUtilities.getInstance().dumpComponentHierarchy(this.getNode()), (Throwable)rex);
                                }
                                if ((msg = rex.getLocalizedMessage()) == null) {
                                    msg = rex.getClass().getName();
                                }
                            } else {
                                msg = vx.resultsAsMessage();
                            }
                            this.handleInputFailure(msg);
                        }
                    }
                    this.triggerViewModified();
                }
                finally {
                    this.updatingModel = false;
                }
            }
        }
    }

    protected void handleInputFailure(String msg) {
        block2: {
            block3: {
                Node node;
                this.setError(msg);
                this.setErrorTemporary(true);
                Scene scene = this.getNode().getScene();
                if (scene == null || (node = scene.getFocusOwner()) == this.getNode()) break block2;
                if (!(node instanceof FxComponent)) break block3;
                if (((FxComponent)node).getError() != null) break block2;
            }
            Platform.runLater(() -> ((Node)((Node)this.getComponent())).requestFocus());
        }
    }

    @Override
    public boolean isModelUpdated() {
        return this.modelUpdated;
    }

    @Override
    public void showErrorPopup() {
        this.hideErrorPopup();
        this.errorPopup = FxUtilities.getInstance().showErrorPopup(this.getComponent());
    }

    @Override
    public void hideErrorPopup() {
        if (this.errorPopup != null) {
            this.errorPopup.hide();
            this.errorPopup = null;
        }
    }

    @Override
    public String getError() {
        return this.errorMessage;
    }

    @Override
    public void setError(String errorMessage) {
        boolean changed = !Objects.equals(this.errorMessage, errorMessage);
        this.errorMessage = errorMessage;
        if (changed) {
            this.updateErrorStyle(errorMessage != null && this.isChangeable());
        }
        if (errorMessage == null) {
            this.errorTemporary = false;
        }
    }

    @Override
    public void setErrorTemporary(boolean errorTemporary) {
        this.errorTemporary = errorTemporary;
    }

    @Override
    public boolean isErrorTemporary() {
        return this.errorTemporary;
    }

    protected void updateErrorStyle(boolean enable) {
        if (!enable) {
            this.getNode().getStyleClass().remove((Object)ERROR_STYLE);
        } else if (!this.getNode().getStyleClass().contains((Object)ERROR_STYLE)) {
            this.getNode().getStyleClass().add((Object)ERROR_STYLE);
        }
        if (!enable || this.getNode().isFocused()) {
            this.showErrorPopup();
        }
    }

    @Override
    public void showInfoPopup() {
        this.hideInfoPopup();
        this.infoPopup = FxUtilities.getInstance().showInfoPopup(this.getComponent());
    }

    @Override
    public void hideInfoPopup() {
        if (this.infoPopup != null) {
            this.infoPopup.hide();
            this.infoPopup = null;
        }
    }

    @Override
    public String getInfo() {
        return this.infoMessage;
    }

    @Override
    public void setInfo(String infoMessage) {
        boolean changed = !Objects.equals(this.infoMessage, infoMessage);
        this.infoMessage = infoMessage;
        if (changed) {
            this.updateInfoStyle(infoMessage != null && this.isChangeable());
        }
    }

    protected void updateInfoStyle(boolean enable) {
        if (!enable) {
            this.getNode().getStyleClass().remove((Object)INFO_STYLE);
        } else if (!this.getNode().getStyleClass().contains((Object)INFO_STYLE)) {
            this.getNode().getStyleClass().add((Object)INFO_STYLE);
        }
        if (!enable || this.getNode().isFocused()) {
            this.showInfoPopup();
        }
    }

    @Override
    public void triggerViewModified() {
        if (this.isSavedViewObjectValid()) {
            boolean viewModified = !Objects.equals(this.getViewObject(), this.getSavedViewObject());
            this.setViewModified(viewModified);
            if (this.getParentContainer() != null) {
                this.getParentContainer().triggerViewModified();
            }
            if (viewModified && !this.isErrorTemporary()) {
                this.setError(null);
            }
        }
    }

    @Override
    public void saveView() {
        this.savedViewObject = this.getViewObject();
        this.savedViewObjectValid = true;
        this.setViewModified(false);
    }

    @Override
    public void invalidateSavedView() {
        this.savedViewObjectValid = false;
    }

    @Override
    public boolean isSavedViewObjectValid() {
        return this.savedViewObjectValid;
    }

    @Override
    public Object getSavedViewObject() {
        if (!this.savedViewObjectValid) {
            throw new FxRuntimeException("saved value is invalid in " + this.getComponent());
        }
        return this.savedViewObject;
    }

    @Override
    public void setType(Class<?> type) {
        if (this.type != null && this.type != type) {
            throw new FxRuntimeException("type already set to " + this.type + " (requested " + type + ") for " + this.getComponent());
        }
        this.type = type;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (this.mandatoryProperty != null) {
            this.mandatoryProperty.set(mandatory);
        } else {
            this.mandatory = mandatory;
            this.updateMandatoryStyle(mandatory);
        }
    }

    @Override
    public boolean isMandatory() {
        if (this.mandatoryProperty != null) {
            return this.mandatoryProperty.get();
        }
        return this.mandatory;
    }

    @Override
    public BooleanProperty mandatoryProperty() {
        if (this.mandatoryProperty == null) {
            this.mandatoryProperty = new SimpleBooleanProperty(this.mandatory);
            this.mandatoryProperty.addListener((obs, ov, nv) -> this.updateMandatoryStyle((boolean)nv));
        }
        return this.mandatoryProperty;
    }

    protected void updateMandatoryStyle(boolean mandatory) {
        if (mandatory && !this.getNode().isDisabled()) {
            if (!this.getNode().getStyleClass().contains((Object)MANDATORY_STYLE)) {
                this.getNode().getStyleClass().add((Object)MANDATORY_STYLE);
            }
        } else {
            this.getNode().getStyleClass().remove((Object)MANDATORY_STYLE);
        }
    }

    @Override
    public void setBindingPath(String bindingPath) {
        this.bindingPath = bindingPath;
    }

    @Override
    public String getBindingPath() {
        return this.bindingPath;
    }

    @Override
    public void setComponentPath(String componentPath) {
        this.componentPath = componentPath;
    }

    @Override
    public String getComponentPath() {
        return this.componentPath;
    }

    @Override
    public void setBinding(FxComponentBinding binding) {
        this.binding = binding;
    }

    @Override
    public FxComponentBinding getBinding() {
        return this.binding;
    }

    @Override
    public FxTableCell<?, ?> getTableCell() {
        return this.tableCell;
    }

    @Override
    public void setTableCell(FxTableCell<?, ?> tableCell) {
        this.tableCell = tableCell;
    }
}

