/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.apt;

import java.util.List;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import org.tentackle.apt.AbstractServiceAnnotationProcessor;
import org.tentackle.common.AnnotationProcessor;
import org.tentackle.fx.FxComponent;

@SupportedAnnotationTypes(value={"org.tentackle.fx.ValueTranslatorService"})
@AnnotationProcessor
public class ValueTranslatorServiceAnnotationProcessor
extends AbstractServiceAnnotationProcessor {
    private final TypeVisitor<Boolean, Void> componentVisitor = new SimpleTypeVisitor8<Boolean, Void>(){

        @Override
        public Boolean visitExecutable(ExecutableType t, Void v) {
            List<? extends TypeMirror> typeList = t.getParameterTypes();
            return typeList.size() == 1 && ValueTranslatorServiceAnnotationProcessor.this.acceptTypeVisitor(typeList.get(0), FxComponent.class);
        }
    };
    private final TypeVisitor<Boolean, Void> componentClassVisitor = new SimpleTypeVisitor8<Boolean, Void>(){

        @Override
        public Boolean visitExecutable(ExecutableType t, Void v) {
            List<? extends TypeMirror> typeList = t.getParameterTypes();
            return typeList.size() == 2 && ValueTranslatorServiceAnnotationProcessor.this.acceptTypeVisitor(typeList.get(0), FxComponent.class) && ValueTranslatorServiceAnnotationProcessor.this.typeUtils.erasure(typeList.get(1)).toString().equals("java.lang.Class");
        }
    };

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (TypeElement typeElement : annotations) {
                for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                    this.processClass(element);
                }
            }
        }
        return true;
    }

    protected void processClass(Element element) {
        super.processClass(element);
        if (!this.verifyConstructor(element, this.componentVisitor) && !this.verifyConstructor(element, this.componentClassVisitor)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "class " + element + " needs constructor (FxComponent) or (FxComponent, Class)", element);
        }
        this.verifyImplements(element, "org.tentackle.fx.ValueTranslator");
    }
}

