/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.bind;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.tentackle.bind.AbstractBinder;
import org.tentackle.bind.BindableElement;
import org.tentackle.bind.Binding;
import org.tentackle.bind.BindingException;
import org.tentackle.bind.BindingMember;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.bind.FxBindingFactory;
import org.tentackle.fx.bind.FxTableBinder;
import org.tentackle.fx.bind.FxTableBinding;
import org.tentackle.fx.table.TableColumnConfiguration;
import org.tentackle.fx.table.TableConfiguration;

public class DefaultFxTableBinder<S>
extends AbstractBinder
implements FxTableBinder<S> {
    private final TableConfiguration<S> tableConfig;
    private final Map<String, FxTableBinding<S, ?>> boundPaths;

    public DefaultFxTableBinder(TableConfiguration<S> tableConfiguration) {
        this.tableConfig = tableConfiguration;
        this.boundPaths = new TreeMap();
    }

    @Override
    public TableConfiguration<S> getTableConfiguration() {
        return this.tableConfig;
    }

    public int bindAllInherited() {
        return this.doBind(null, null, this.getTableConfiguration().getObjectClass(), false);
    }

    public int bind() {
        return this.doBind(null, null, this.getTableConfiguration().getObjectClass(), true);
    }

    public void unbind() {
        this.boundPaths.clear();
    }

    public Collection<FxTableBinding<S, ?>> getBindings() {
        return this.boundPaths.values();
    }

    @Override
    public Collection<String> getBoundColumns() {
        return this.boundPaths.keySet();
    }

    @Override
    public Collection<String> getUnboundColumns() {
        ArrayList<String> unboundColumns = new ArrayList<String>();
        for (TableColumnConfiguration<S, ?> column : this.tableConfig.getColumnConfigurations()) {
            if (this.boundPaths.containsKey(column.getName())) continue;
            unboundColumns.add(column.getName());
        }
        return unboundColumns;
    }

    public void assertAllBound() {
        Collection<String> unboundColumns = this.getUnboundColumns();
        if (!unboundColumns.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (String columnName : unboundColumns) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(columnName);
            }
            throw new BindingException("unbound columns in " + this.tableConfig + ": " + buf);
        }
    }

    public void addBinding(Binding binding) {
        FxTableBinding oldBinding;
        if (binding instanceof FxTableBinding && (oldBinding = this.boundPaths.put(binding.getMember().getMemberPath(), (FxTableBinding)binding)) != null) {
            throw new BindingException(binding + ": binding path '" + binding.getMember().getMemberPath() + "' already bound to column " + oldBinding.getConfiguration().getName());
        }
    }

    @Override
    public FxTableBinding<S, ?> getBinding(String bindingPath) {
        return this.boundPaths.get(bindingPath);
    }

    public FxTableBinding<S, ?> removeBinding(String bindingPath) {
        return this.boundPaths.remove(bindingPath);
    }

    protected int doBind(BindingMember[] parents, String parentMemberPath, Class<?> parentClass, boolean declaredOnly) {
        if (parentMemberPath != null) {
            boolean found = false;
            for (TableColumnConfiguration<S, Object> tableColumnConfiguration : this.tableConfig.getColumnConfigurations()) {
                String bindingPath = tableColumnConfiguration.getName();
                if (bindingPath == null || !bindingPath.startsWith(parentMemberPath)) continue;
                found = true;
                break;
            }
            if (!found) {
                return 0;
            }
        }
        int count = 0;
        for (BindableElement bindableElement : FxBindingFactory.getInstance().getBindableCache().getBindableMap(parentClass, declaredOnly).values()) {
            String fieldMemberName = StringHelper.firstToLower((String)bindableElement.getCamelName());
            String fieldMemberPath = (String)(parentMemberPath == null ? "" : parentMemberPath + ".") + fieldMemberName;
            BindingMember[] fieldParents = new BindingMember[parents == null ? 1 : parents.length + 1];
            BindingMember fieldMember = FxBindingFactory.getInstance().createBindingMember(parentClass, parents == null ? null : parents[parents.length - 1], fieldMemberName, fieldMemberPath, bindableElement);
            if (parents != null) {
                System.arraycopy(parents, 0, fieldParents, 0, parents.length);
                fieldParents[parents.length] = fieldMember;
            } else {
                fieldParents[0] = fieldMember;
            }
            try {
                for (TableColumnConfiguration<S, ?> columnConfig : this.tableConfig.getColumnConfigurations()) {
                    String bindingPath = columnConfig.getName();
                    if (bindingPath == null || !bindingPath.equals(fieldMemberPath)) continue;
                    this.addBinding(FxBindingFactory.getInstance().createTableBinding(this, parents, fieldMember, columnConfig, bindableElement.getBindingOptions()));
                    ++count;
                }
                count += this.doBind(fieldParents, fieldMemberPath, fieldMember.getType(), declaredOnly);
            }
            catch (RuntimeException ex) {
                throw new BindingException("binding " + fieldMemberPath + " failed", (Throwable)ex);
            }
        }
        return count;
    }
}

