/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component;

import javafx.animation.PauseTransition;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.stage.PopupWindow;
import javafx.util.Duration;
import org.tentackle.fx.FxComponent;
import org.tentackle.fx.FxUtilities;
import org.tentackle.fx.InfoPopupSupported;

public class FxButton
extends Button
implements InfoPopupSupported {
    public static double doClickPressTime = 200.0;
    private String infoMessage;
    private PopupWindow infoPopup;

    public FxButton() {
        this.configure();
    }

    public FxButton(String text) {
        super(text);
        this.configure();
    }

    public FxButton(String text, Node graphic) {
        super(text, graphic);
        this.configure();
    }

    public void doClick(double pressTime) {
        PauseTransition pause = new PauseTransition(Duration.millis((double)pressTime));
        pause.setOnFinished(e -> {
            this.disarm();
            this.fire();
        });
        this.arm();
        pause.play();
    }

    public void doClick() {
        this.doClick(doClickPressTime);
    }

    public void fire() {
        Node node;
        if (!this.isFocusTraversable() && !this.isCancelButton() && (node = this.getScene().getFocusOwner()) instanceof FxComponent) {
            FxUtilities.getInstance().focusLost((FxComponent)node);
        }
        super.fire();
    }

    @Override
    public void showInfoPopup() {
        this.hideInfoPopup();
        this.infoPopup = FxUtilities.getInstance().showInfoPopup(this);
    }

    @Override
    public void hideInfoPopup() {
        if (this.infoPopup != null) {
            this.infoPopup.hide();
            this.infoPopup = null;
        }
    }

    @Override
    public String getInfo() {
        return this.infoMessage;
    }

    @Override
    public void setInfo(String infoMessage) {
        boolean wasInfoMessage = this.infoMessage != null;
        this.infoMessage = infoMessage;
        if (wasInfoMessage == (infoMessage == null)) {
            if (wasInfoMessage) {
                this.getStyleClass().remove((Object)"tt-info");
            } else if (!this.getStyleClass().contains((Object)"tt-info")) {
                this.getStyleClass().add((Object)"tt-info");
            }
            if (this.isHover()) {
                this.showInfoPopup();
            }
        }
    }

    protected void configure() {
        this.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.showInfoPopup();
            } else {
                this.hideInfoPopup();
            }
        });
    }
}

