/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;
import org.tentackle.fx.Fx;
import org.tentackle.fx.component.skin.NoteSkin;

public class Note
extends PopupControl {
    private final Position position;
    private final Type type;
    private final StackPane rootPane;
    private Node contentNode;
    private ObjectProperty<Node> contentNodeProperty;

    public Note(Position position, Type type) {
        this.position = position;
        this.type = type;
        this.getStyleClass().add((Object)"note");
        this.rootPane = new StackPane();
        this.rootPane.getStylesheets().add((Object)Note.class.getResource("note.css").toExternalForm());
        this.getStyleClass().add((Object)type.getCssClass());
        this.getStyleClass().add((Object)position.getCssClass());
        this.contentNode = new Label("???");
    }

    protected Skin<?> createDefaultSkin() {
        return new NoteSkin(this);
    }

    public Position getPosition() {
        return this.position;
    }

    public Type getType() {
        return this.type;
    }

    public StackPane getRootPane() {
        return this.rootPane;
    }

    public ObjectProperty<Node> contentNodeProperty() {
        if (this.contentNodeProperty == null) {
            this.contentNodeProperty = new SimpleObjectProperty((Object)this, "contentNode");
        }
        return this.contentNodeProperty;
    }

    public Node getContentNode() {
        if (this.contentNodeProperty != null) {
            return (Node)this.contentNodeProperty.get();
        }
        return this.contentNode;
    }

    public void setContentNode(Node contentNode) {
        if (this.contentNodeProperty != null) {
            this.contentNodeProperty.set((Object)contentNode);
        } else {
            this.contentNode = contentNode;
        }
    }

    public void show(Node ownerNode) {
        if (ownerNode != null && Fx.getStage(ownerNode) != null) {
            super.show(ownerNode, 0.0, 0.0);
        }
    }

    public void setText(String text) {
        Label label = new Label(text);
        label.getStyleClass().add((Object)"text");
        this.setContentNode((Node)label);
    }

    public static enum Position {
        RIGHT("right"),
        LEFT("left"),
        TOP("top"),
        BOTTOM("bottom"),
        CENTER("center");

        private final String cssClass;

        private Position(String cssClass) {
            this.cssClass = cssClass;
        }

        public String getCssClass() {
            return this.cssClass;
        }
    }

    public static enum Type {
        ERROR("error"),
        INFO("info"),
        STICKY("sticky");

        private final String cssClass;

        private Type(String cssClass) {
            this.cssClass = cssClass;
        }

        public String getCssClass() {
            return this.cssClass;
        }
    }
}

