/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.config;

import java.util.Collection;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import org.tentackle.fx.FxUtilities;

public class PrefixSelectionFeature<T extends Control> {
    public static final String ENABLED = "prefixSelectionEnabled";
    protected final T control;
    protected final BooleanSupplier asYouTypeCondition;
    protected final Supplier<Collection> itemProvider;
    protected final Supplier<StringConverter> itemConverter;
    protected final Consumer<Integer> selector;
    protected final StringBuilder prefixBuf;
    private long lastPressMillis;
    private Integer index;
    private boolean isDropDownVisible;

    public PrefixSelectionFeature(T control, BooleanSupplier asYouTypeCondition, Supplier<Collection> itemProvider, Supplier<StringConverter> itemConverter, Consumer<Integer> selector) {
        this.control = control;
        this.asYouTypeCondition = asYouTypeCondition;
        this.itemProvider = itemProvider;
        this.itemConverter = itemConverter;
        this.selector = selector;
        this.prefixBuf = new StringBuilder();
    }

    public void configure() {
        this.control.addEventHandler(KeyEvent.KEY_TYPED, this.createHandler());
        if (this.control instanceof ComboBoxBase) {
            ((ComboBoxBase)this.control).showingProperty().addListener((obs, wasShowing, isShowing) -> {
                this.isDropDownVisible = isShowing;
                if (this.isDropDownVisible && this.isEnabled()) {
                    String value;
                    boolean clearIndex = false;
                    if (this.index == null && this.control instanceof ComboBox && ((ComboBox)this.control).isEditable() && (value = ((ComboBox)this.control).getEditor().getText()) != null) {
                        this.prefixBuf.append(value);
                        this.select();
                        clearIndex = true;
                    }
                    if (this.index != null) {
                        this.scrollToIndexInDropDown();
                        if (clearIndex) {
                            this.index = null;
                            this.prefixBuf.setLength(0);
                        }
                    }
                }
            });
        }
    }

    protected void scrollToIndexInDropDown() {
        Skin skin;
        if (this.index != null && (skin = this.control.getSkin()) instanceof ComboBoxListViewSkin) {
            ((ListView)((ComboBoxListViewSkin)skin).getPopupContent()).scrollTo(this.index.intValue());
        }
    }

    protected EventHandler<KeyEvent> createHandler() {
        return event -> {
            String chr;
            if (this.isSelectionByKeyEnabled() && (chr = event.getCharacter()) != null) {
                long now = System.currentTimeMillis();
                if (now > this.lastPressMillis + FxUtilities.getInstance().getPrefixSelectionTimeout()) {
                    this.prefixBuf.setLength(0);
                    this.index = null;
                }
                this.lastPressMillis = now;
                this.prefixBuf.append(chr);
                this.select();
            }
        };
    }

    protected boolean isEnabled() {
        return this.control.getProperties().containsKey((Object)ENABLED);
    }

    protected boolean isSelectionByKeyEnabled() {
        return this.asYouTypeCondition.getAsBoolean() && this.isEnabled();
    }

    protected void select() {
        String prefix = this.getPrefix();
        int i = 0;
        for (Object item : this.itemProvider.get()) {
            if ((this.index == null || i >= this.index) && this.isItemMatching(prefix, item)) {
                this.index = i;
                this.selector.accept(this.index);
                if (!this.isDropDownVisible) break;
                this.scrollToIndexInDropDown();
                break;
            }
            ++i;
        }
    }

    protected String getPrefix() {
        return this.prefixBuf.toString().toUpperCase();
    }

    protected boolean isItemMatching(String prefix, Object item) {
        StringConverter converter = this.itemConverter == null ? null : this.itemConverter.get();
        String itemText = converter == null ? item.toString() : converter.toString(item);
        return itemText != null && itemText.toUpperCase().startsWith(prefix);
    }
}

