/*
 * Decompiled with CFR 0.152.
 */
package org.tentackle.fx.component.delegate;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import javafx.scene.control.TextFormatter;
import org.tentackle.common.StringHelper;
import org.tentackle.fx.FxContainer;
import org.tentackle.fx.FxTextComponentDelegate;
import org.tentackle.fx.ValueTranslator;
import org.tentackle.fx.component.FxComboBox;

public class FxComboBoxDelegate
extends FxTextComponentDelegate {
    private final FxComboBox<?> component;

    public FxComboBoxDelegate(FxComboBox<?> component) {
        this.component = component;
        component.getEditor().setTextFormatter(new TextFormatter((UnaryOperator)this));
    }

    @Override
    public FxComboBox<?> getComponent() {
        return this.component;
    }

    @Override
    public FxContainer getParentContainer() {
        Parent parent = this.component.getParent();
        return parent instanceof FxContainer ? (FxContainer)parent : null;
    }

    @Override
    public void setColumns(int columns) {
        this.component.getEditor().setPrefColumnCount(columns);
    }

    @Override
    public int getColumns() {
        return this.component.getEditor().getPrefColumnCount();
    }

    @Override
    public void setType(Class<?> type) {
        super.setType(type);
        if (type.isEnum()) {
            ObservableList items = this.component.getItems();
            items.clear();
            items.addAll(Arrays.asList(type.getEnumConstants()));
        }
    }

    @Override
    public Object getViewObject() {
        if (this.component.isEditable()) {
            String text = this.component.getEditor().getText();
            return StringHelper.isAllWhitespace((String)text) ? null : text;
        }
        return this.component.getSelectionModel().getSelectedItem();
    }

    @Override
    public void setViewObject(Object viewObject) {
        if (this.component.isEditable()) {
            Pos alignment = this.component.getTextAlignment();
            if (alignment != null) {
                this.component.getEditor().setAlignment(alignment);
            }
            this.component.getEditor().setText((String)viewObject);
        } else if (!Objects.equals(this.getViewObject(), viewObject)) {
            this.component.getSelectionModel().select(viewObject);
        }
    }

    @Override
    public void setViewValue(Object value) {
        if (this.component.isEditable()) {
            ValueTranslator<?, ?> translator = this.getValueTranslator();
            value = translator.toView(value);
        }
        this.setViewObject(value);
    }

    @Override
    public <V> V getViewValue() {
        Object value = this.getViewObject();
        if (this.component.isEditable()) {
            ValueTranslator<?, ?> translator = this.getValueTranslator();
            return (V)translator.toModel(value);
        }
        return (V)value;
    }

    @Override
    public void mapErrorOffsetToCaretPosition() {
        Integer errorOffset = this.getErrorOffset();
        if (errorOffset != null && this.component.isEditable()) {
            Platform.runLater(() -> {
                this.component.getEditor().deselect();
                this.component.getEditor().positionCaret(errorOffset.intValue());
            });
        }
    }

    public boolean isDeselectAllowed() {
        Boolean allowed = this.component.isDeselectAllowed();
        if (allowed != null) {
            return allowed;
        }
        return (this.getType() == null || !this.getType().isPrimitive()) && !this.component.isMandatory();
    }

    @Override
    public void autoSelect() {
        if (this.component.isEditable()) {
            if (this.isAutoSelect()) {
                this.component.getEditor().selectAll();
            } else {
                this.component.getEditor().deselect();
            }
        }
    }
}

